/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.EnumHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;

public class Argument
implements Cloneable {
    private String raw_value;
    public String prefix = null;
    public String lower_prefix = null;
    private String value;
    public String lower_value;
    public ObjectTag object = null;
    public ScriptEntry scriptEntry = null;
    public boolean canBeElement = true;
    public boolean prefixWasDynamic = false;
    public static AsciiMatcher prefixCharsAllowed = new AsciiMatcher("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_.");

    public Argument clone() {
        try {
            return (Argument)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public void unsetValue() {
        this.raw_value = null;
    }

    public ObjectTag getRawObject() {
        if (this.prefix == null) {
            return this.object;
        }
        return this.getRawElement();
    }

    public ElementTag getRawElement() {
        if (this.prefix == null) {
            return this.asElement();
        }
        ElementTag result = new ElementTag(this.getRawValue());
        result.isRawInput = true;
        return result;
    }

    public String getRawValue() {
        this.requireValue();
        return this.raw_value;
    }

    public void requireValue() {
        if (this.raw_value == null && this.object != null) {
            this.value = this.object.toString();
            this.lower_value = CoreUtilities.toLowerCase(this.value);
            this.raw_value = this.prefix == null ? this.value : this.prefix + ":" + this.value;
        }
    }

    public Argument(String prefix, String value) {
        this.prefix = prefix;
        this.value = value;
        if (prefix != null) {
            if (prefix.equals("no_prefix")) {
                this.prefix = null;
                this.raw_value = this.value;
            } else {
                this.raw_value = prefix + ":" + this.value;
                this.lower_prefix = CoreUtilities.toLowerCase(prefix);
            }
        } else {
            this.raw_value = this.value;
        }
        this.lower_value = CoreUtilities.toLowerCase(this.value);
        this.object = new ElementTag(this.value);
        ((ElementTag)this.object).isRawInput = true;
    }

    private void fillStrNoColon(String string) {
        this.value = string;
        if (this.object == null) {
            this.object = new ElementTag(this.value);
            ((ElementTag)this.object).isRawInput = true;
        }
        this.lower_value = CoreUtilities.toLowerCase(this.value);
    }

    public void fillStr(String string) {
        this.raw_value = string;
        int first_colon = string.indexOf(58);
        if (first_colon == -1) {
            this.fillStrNoColon(string);
            return;
        }
        int first_not_prefix = prefixCharsAllowed.indexOfFirstNonMatch(string);
        if (first_not_prefix > -1 && first_not_prefix < first_colon) {
            this.fillStrNoColon(string);
            return;
        }
        this.prefix = string.substring(0, first_colon);
        if (this.prefix.equals("no_prefix")) {
            this.prefix = null;
        } else {
            this.lower_prefix = CoreUtilities.toLowerCase(this.prefix);
        }
        this.fillStrNoColon(string.substring(first_colon + 1));
    }

    public Argument(String string) {
        this.fillStr(string);
    }

    public static Argument valueOf(String string) {
        return new Argument(string);
    }

    public boolean startsWith(String string) {
        if (!this.canBeElement && !CoreUtilities.contains(string, '@')) {
            return false;
        }
        this.requireValue();
        return this.lower_value.startsWith(string);
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public Argument getPrefix() {
        if (this.prefix == null) {
            return null;
        }
        return Argument.valueOf(this.prefix);
    }

    public boolean matches(String value) {
        if (!this.canBeElement) {
            return false;
        }
        this.requireValue();
        return value.equals(this.lower_value);
    }

    public boolean matches(String ... values) {
        if (!this.canBeElement) {
            return false;
        }
        this.requireValue();
        for (String value : values) {
            if (!value.equals(this.lower_value)) continue;
            return true;
        }
        return false;
    }

    public String getValue() {
        this.requireValue();
        return this.value;
    }

    public ListTag getList(TagContext context) {
        if (this.object instanceof ListTag) {
            return (ListTag)this.object;
        }
        if (this.object instanceof ElementTag) {
            if (context == null && this.scriptEntry != null) {
                context = this.scriptEntry.getContext();
            }
            this.requireValue();
            return ListTag.valueOf(this.value, context);
        }
        ListTag result = new ListTag();
        result.addObject(this.object);
        return result;
    }

    public boolean matchesEnum(Class<? extends Enum> clazz) {
        this.requireValue();
        return EnumHelper.get(clazz).valuesMapLower.containsKey(EnumHelper.cleanKey(this.value));
    }

    @Deprecated
    public boolean matchesEnum(Enum<?>[] values) {
        if (!this.canBeElement) {
            return false;
        }
        this.requireValue();
        String upper = this.value.replace("_", "").toUpperCase();
        for (Enum<?> value : values) {
            if (!value.name().replace("_", "").equals(upper)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesEnumList(Class<? extends Enum> clazz) {
        ListTag list = this.getList(CoreUtilities.noDebugContext);
        EnumHelper<? extends Enum> helper = EnumHelper.get(clazz);
        for (String string : list) {
            if (!helper.valuesMapLower.containsKey(EnumHelper.cleanKey(string))) continue;
            return true;
        }
        return false;
    }

    public boolean limitToOnlyPrefix(String value) {
        if (!this.hasPrefix()) {
            return true;
        }
        return value.equals(this.lower_prefix);
    }

    public boolean matchesPrefix(String value) {
        if (!this.hasPrefix()) {
            return false;
        }
        if (value.equals(this.lower_prefix)) {
            if (this.prefixWasDynamic) {
                Deprecations.dynamicPrefix.warn(this.scriptEntry);
            }
            return true;
        }
        return false;
    }

    public boolean matchesPrefix(String ... values) {
        if (!this.hasPrefix()) {
            return false;
        }
        for (String value : values) {
            if (!value.equals(this.lower_prefix)) continue;
            if (this.prefixWasDynamic) {
                Deprecations.dynamicPrefix.warn(this.scriptEntry);
            }
            return true;
        }
        return false;
    }

    public boolean matchesBoolean() {
        if (!this.canBeElement) {
            return false;
        }
        this.requireValue();
        return this.lower_value.equals("true") || this.lower_value.equals("false");
    }

    public boolean matchesInteger() {
        return this.matchesFloat();
    }

    public boolean matchesFloat() {
        if (!this.canBeElement) {
            return false;
        }
        this.requireValue();
        return ArgumentHelper.matchesDouble(this.lower_value);
    }

    public boolean matchesArgumentType(Class<? extends ObjectTag> dClass) {
        return this.object.canBeType(dClass);
    }

    @SafeVarargs
    public final boolean matchesArgumentTypes(Class<? extends ObjectTag> ... dClasses) {
        for (Class<? extends ObjectTag> c : dClasses) {
            if (!this.matchesArgumentType(c)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesArgumentList(Class<? extends ObjectTag> dClass) {
        ListTag list = this.getList(CoreUtilities.noDebugContext);
        return list.isEmpty() || list.containsObjectsFrom(dClass);
    }

    public ElementTag asElement() {
        if (this.object instanceof ElementTag) {
            return (ElementTag)this.object;
        }
        this.requireValue();
        return new ElementTag(this.prefix, this.value);
    }

    public <T extends ObjectTag> T asType(Class<T> clazz) {
        T arg = this.object.asType(clazz, this.scriptEntry.context);
        if (arg == null) {
            Debug.echoError("Cannot process argument '" + this.object + "' as type '" + DebugInternals.getClassNameOpti(clazz) + "' (conversion returned null).");
            return null;
        }
        arg.setPrefix(this.prefix);
        return arg;
    }

    public void reportUnhandled() {
        if (TagManager.recentTagError) {
            Debug.echoError('\'' + this.getRawValue() + "' is an unknown argument! This was probably caused by a tag not parsing properly.");
            return;
        }
        if (this.prefix != null) {
            Debug.echoError('\'' + this.getRawValue() + "' is an unknown argument! Did you mess up the command syntax?");
        } else {
            Debug.echoError('\'' + this.getRawValue() + "' is an unknown argument! Did you forget quotes, or did you mess up the command syntax?");
        }
        if (this.scriptEntry != null && this.scriptEntry.getCommand() != null) {
            Debug.log("Command usage: " + this.scriptEntry.getCommand().getUsageHint());
        }
    }

    public String toString() {
        return this.getRawValue();
    }
}

