/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.spigotmc.event.entity.EntityMountEvent;

public class EntityEntersVehicleScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag vehicle;
    public EntityTag entity;
    public EntityMountEvent event;
    public static HashSet<String> notRelevantEnterables = new HashSet<String>(Arrays.asList("notable", "cuboid", "biome", "bed", "portal"));

    public EntityEntersVehicleScriptEvent() {
        this.registerCouldMatcher("<entity> enters <entity>");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return !notRelevantEnterables.contains(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        String vehicleLabel = path.eventArgLowerAt(2);
        if (!vehicleLabel.equals("vehicle") && !this.vehicle.tryAdvancedMatcher(vehicleLabel)) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle.getDenizenObject();
        }
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityEntersVehicle(EntityMountEvent event) {
        this.vehicle = new EntityTag(event.getMount());
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

