/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.impl.network.packets;

import com.denizenscript.denizen.nms.interfaces.packets.PacketOutChat;
import com.denizenscript.denizen.nms.v1_16.Handler;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_16_R3.ChatMessageType;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.PacketPlayOutChat;

public class PacketOutChatImpl
implements PacketOutChat {
    private PacketPlayOutChat internal;
    private String message;
    private String rawJson;
    private boolean bungee;
    private ChatMessageType position;
    private static final Field MESSAGE;
    private static final Field POSITION;

    public PacketOutChatImpl(PacketPlayOutChat internal) {
        this.internal = internal;
        try {
            IChatBaseComponent baseComponent = (IChatBaseComponent)MESSAGE.get(internal);
            if (baseComponent != null) {
                this.message = FormattedTextHelper.stringify(Handler.componentToSpigot(baseComponent), ChatColor.WHITE);
                this.rawJson = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)baseComponent);
            } else {
                if (internal.components != null) {
                    this.message = FormattedTextHelper.stringify(internal.components, ChatColor.WHITE);
                    this.rawJson = ComponentSerializer.toString((BaseComponent[])internal.components);
                }
                this.bungee = true;
            }
            this.position = (ChatMessageType)POSITION.get(internal);
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    @Override
    public boolean isSystem() {
        return this.position == ChatMessageType.SYSTEM;
    }

    @Override
    public boolean isActionbar() {
        return this.position == ChatMessageType.GAME_INFO;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getRawJson() {
        return this.rawJson;
    }

    public void setRawJson(String rawJson) {
        try {
            if (!this.bungee) {
                MESSAGE.set(this.internal, IChatBaseComponent.ChatSerializer.a((String)rawJson));
            } else {
                this.internal.components = ComponentSerializer.parse((String)rawJson);
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    static {
        ReflectionHelper.CheckingFieldMap fields = ReflectionHelper.getFields(PacketPlayOutChat.class);
        MESSAGE = (Field)fields.get("a");
        POSITION = (Field)fields.get("b");
    }
}

