/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;

public class BukkitQueueExtensions {
    public static void register() {
        QueueTag.tagProcessor.registerTag(NPCTag.class, "npc", (attribute, object) -> {
            NPCTag npc = null;
            if (object.queue.getLastEntryExecuted() != null) {
                npc = ((BukkitScriptEntryData)object.queue.getLastEntryExecuted().entryData).getNPC();
            } else if (object.queue.getEntries().size() > 0) {
                npc = ((BukkitScriptEntryData)object.queue.getEntries().get((int)0).entryData).getNPC();
            } else if (!attribute.hasAlternative()) {
                attribute.echoError("Can't determine a linked NPC.");
            }
            return npc;
        }, new String[0]);
        QueueTag.tagProcessor.registerTag(PlayerTag.class, "player", (attribute, object) -> {
            PlayerTag player = null;
            if (object.queue.getLastEntryExecuted() != null) {
                player = ((BukkitScriptEntryData)object.queue.getLastEntryExecuted().entryData).getPlayer();
            } else if (object.queue.getEntries().size() > 0) {
                player = ((BukkitScriptEntryData)object.queue.getEntries().get((int)0).entryData).getPlayer();
            } else {
                attribute.echoError("Can't determine a linked player.");
            }
            return player;
        }, new String[0]);
        QueueTag.tagProcessor.registerMechanism("linked_player", false, PlayerTag.class, (queue, mechanism, player) -> {
            for (ScriptEntry entry : queue.queue.getEntries()) {
                BukkitScriptEntryData data = (BukkitScriptEntryData)entry.entryData;
                data.setPlayer((PlayerTag)player);
            }
        });
        QueueTag.tagProcessor.registerMechanism("linked_npc", false, NPCTag.class, (queue, mechanism, npc) -> {
            for (ScriptEntry entry : queue.queue.getEntries()) {
                BukkitScriptEntryData data = (BukkitScriptEntryData)entry.entryData;
                data.setNPC((NPCTag)npc);
            }
        });
    }
}

