/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockSpreadEvent;

public class BlockSpreadsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag material;
    public BlockSpreadEvent event;

    public BlockSpreadsScriptEvent() {
        this.registerCouldMatcher("block spreads");
        this.registerCouldMatcher("<block> spreads");
        this.registerSwitches("type");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        if (path.eventArgLowerAt(0).equals("liquid")) {
            return false;
        }
        if (!path.eventArgLowerAt(0).equals("block")) {
            BukkitImplDeprecations.blockSpreads.warn(this.getTagContext(path));
        }
        return true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!this.material.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!path.tryObjectSwitch("type", this.material)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "material": {
                return this.material;
            }
            case "source_location": {
                return new LocationTag(this.event.getBlock().getLocation());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockSpreads(BlockSpreadEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getSource());
        this.event = event;
        this.fire((Event)event);
    }
}

