/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerEditsBookScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerEditBookEvent event;
    public PlayerTag player;

    public PlayerEditsBookScriptEvent() {
        this.registerCouldMatcher("player edits book");
        this.registerCouldMatcher("player signs book");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String action = path.eventArgLowerAt(1);
        if (!(action.equals("edits") && !this.event.isSigning() || action.equals("signs") && this.event.isSigning())) {
            return false;
        }
        if (!this.runInCheck(path, this.player.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (CoreUtilities.toLowerCase(determination).equals("not_signing")) {
            this.event.setSigning(false);
            return true;
        }
        if (ScriptTag.matches(determination)) {
            ScriptTag script = ScriptTag.valueOf(determination, this.getTagContext(path));
            if (script.getContainer() instanceof BookScriptContainer) {
                ItemTag dBook = ((BookScriptContainer)script.getContainer()).getBookFrom(this.getScriptEntryData().getTagContext());
                BookMeta bookMeta = (BookMeta)dBook.getItemMeta();
                if (dBook.getMaterial().getMaterial() == Material.WRITABLE_BOOK) {
                    this.event.setSigning(false);
                }
                this.event.setNewBookMeta(bookMeta);
            } else {
                Debug.echoError("Script '" + determination + "' is valid, but not of type 'book'!");
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "signing": {
                return new ElementTag(this.event.isSigning());
            }
            case "title": {
                return this.event.isSigning() ? new ElementTag(this.event.getNewBookMeta().getTitle()) : null;
            }
            case "pages": {
                return new ElementTag(this.event.getNewBookMeta().getPageCount());
            }
            case "book": {
                ItemStack book = new ItemStack(Material.WRITABLE_BOOK);
                book.setItemMeta((ItemMeta)this.event.getNewBookMeta());
                return new ItemTag(book);
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEditsBook(PlayerEditBookEvent event) {
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.event = event;
        this.fire((Event)event);
    }
}

