/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.util.BoundingBox;

public class EntityBoundingBox
implements Property {
    public static final String[] handledMechs = new String[]{"bounding_box"};
    private static Set<UUID> modifiedBoxes = new HashSet<UUID>();
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        return object instanceof EntityTag;
    }

    public static EntityBoundingBox getFrom(ObjectTag object) {
        if (!EntityBoundingBox.describes(object)) {
            return null;
        }
        return new EntityBoundingBox((EntityTag)object);
    }

    public static void remove(UUID uuid) {
        modifiedBoxes.remove(uuid);
    }

    private EntityBoundingBox(EntityTag entity) {
        this.entity = entity;
    }

    private ListTag getBoundingBox() {
        BoundingBox boundingBox = this.entity.getBukkitEntity().getBoundingBox();
        ListTag list = new ListTag();
        list.addObject(new LocationTag(this.entity.getWorld(), boundingBox.getMin()));
        list.addObject(new LocationTag(this.entity.getWorld(), boundingBox.getMax()));
        return list;
    }

    @Override
    public String getPropertyString() {
        if (this.entity.isCitizensNPC()) {
            return null;
        }
        if (modifiedBoxes.contains(this.entity.getUUID())) {
            return this.getBoundingBox().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "bounding_box";
    }

    public static void registerTags() {
        PropertyParser.registerTag(EntityBoundingBox.class, ListTag.class, "bounding_box", (attribute, object) -> object.getBoundingBox(), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("bounding_box") && mechanism.requireObject(ListTag.class)) {
            if (this.entity.isCitizensNPC()) {
                return;
            }
            List<LocationTag> locations = mechanism.valueAsType(ListTag.class).filter(LocationTag.class, mechanism.context);
            if (locations.size() == 2) {
                NMSHandler.entityHelper.setBoundingBox(this.entity.getBukkitEntity(), BoundingBox.of((Location)locations.get(0), (Location)locations.get(1)));
                modifiedBoxes.add(this.entity.getUUID());
            } else {
                mechanism.echoError("Must specify exactly 2 LocationTags in the format '<low>|<high>'!");
            }
        }
    }
}

