/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.commands.queue.DetermineCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatTrigger
extends AbstractTrigger
implements Listener {
    static final Pattern triggerPattern = Pattern.compile("/([^/]*)/");
    public static ChatTrigger instance;

    @Override
    public AbstractTrigger activate() {
        instance = this;
        return super.activate();
    }

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }

    public ChatContext process(Player player, String message) {
        List<InteractScriptContainer> scripts;
        NPCTag npc = Utilities.getClosestNPC_ChatTrigger(player.getLocation(), 25);
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Processing chat trigger: valid npc? " + (npc != null));
        }
        if (npc == null) {
            return new ChatContext(false);
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Has trait?  " + npc.getCitizen().hasTrait(TriggerTrait.class));
        }
        if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
            return new ChatContext(false);
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("enabled? " + ((TriggerTrait)npc.getCitizen().getOrAddTrait(TriggerTrait.class)).isEnabled(this.name));
        }
        if (!((TriggerTrait)npc.getCitizen().getOrAddTrait(TriggerTrait.class)).isEnabled(this.name)) {
            return new ChatContext(false);
        }
        if (npc.getTriggerTrait().getRadius(this.name) < npc.getLocation().distance(player.getLocation())) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Not in range");
            }
            return new ChatContext(false);
        }
        if (Settings.chatMustSeeNPC() && !player.hasLineOfSight(npc.getEntity())) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("no LOS");
            }
            return new ChatContext(false);
        }
        if (Settings.chatMustLookAtNPC() && !NMSHandler.entityHelper.isFacingEntity((Entity)player, npc.getEntity(), 45.0f)) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Not facing");
            }
            return new ChatContext(false);
        }
        boolean ret = false;
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("message", new ElementTag(message));
        TriggerTrait.TriggerContext trigger = npc.getTriggerTrait().trigger(this, new PlayerTag(player), context);
        if (trigger.hasDetermination() && trigger.getDeterminations().containsCaseInsensitive("cancelled")) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Cancelled");
            }
            return new ChatContext(true);
        }
        if (!trigger.wasTriggered()) {
            if (Settings.chatGloballyIfUninteractable()) {
                if (CoreConfiguration.debugVerbose) {
                    Debug.log(ChatColor.YELLOW + "Resuming. " + ChatColor.WHITE + "The NPC is currently cooling down or engaged.");
                }
                return new ChatContext(false);
            }
            ret = true;
        }
        if (trigger.hasDetermination()) {
            message = trigger.getDeterminations().get(0);
        }
        if ((scripts = npc.getInteractScripts(new PlayerTag(player), ChatTrigger.class)) == null) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("null scripts");
            }
            return new ChatContext(message, false);
        }
        ChatContext returnable = new ChatContext(ret);
        for (InteractScriptContainer script : scripts) {
            this.processSingle(message, player, npc, context, script, returnable);
        }
        return returnable;
    }

    public void processSingle(String message, Player player, NPCTag npc, Map<String, ObjectTag> context, InteractScriptContainer script, ChatContext returnable) {
        String step;
        context = new HashMap<String, ObjectTag>(context);
        PlayerTag denizenPlayer = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
        if (script.shouldDebug()) {
            Debug.report((Debuggable)script, this.name, ArgumentHelper.debugObj("Player", player.getName()) + ArgumentHelper.debugObj("NPC", npc.toString()) + ArgumentHelper.debugObj("Radius(Max)", npc.getLocation().distance(player.getLocation()) + "(" + npc.getTriggerTrait().getRadius(this.name) + ")") + ArgumentHelper.debugObj("Trigger text", message) + ArgumentHelper.debugObj("LOS", String.valueOf(player.hasLineOfSight(npc.getEntity()))) + ArgumentHelper.debugObj("Facing", String.valueOf(NMSHandler.entityHelper.isFacingEntity((Entity)player, npc.getEntity(), 45.0f))));
        }
        if (!script.containsTriggerInStep(step = InteractScriptHelper.getCurrentStep(denizenPlayer, script.getName()), ChatTrigger.class)) {
            if (!Settings.chatGloballyIfNoChatTriggers()) {
                Debug.echoDebug((Debuggable)script, player.getName() + " says to " + npc.getNicknameTrait().getNickname() + ", " + message);
            } else if (CoreConfiguration.debugVerbose) {
                Debug.log("No trigger in step, chatting globally");
            }
            return;
        }
        String id = null;
        String replacementText = null;
        String messageLow = CoreUtilities.toLowerCase(message);
        Map<String, String> idMap = script.getIdMapFor(ChatTrigger.class, denizenPlayer);
        if (!idMap.isEmpty()) {
            block0: for (Map.Entry<String, String> entry : idMap.entrySet()) {
                String triggerText = TagManager.tag(entry.getValue(), new BukkitTagContext(denizenPlayer, npc, null, false, null));
                Matcher matcher = triggerPattern.matcher(triggerText);
                while (matcher.find()) {
                    String keywordLow;
                    String keyword = TagManager.tag(matcher.group().replace("/", ""), new BukkitTagContext(denizenPlayer, npc, null, false, null));
                    String[] split = keyword.split("\\\\\\+REPLACE:", 2);
                    String replace = null;
                    if (split.length == 2) {
                        keyword = split[0];
                        replace = split[1];
                    }
                    if ((keywordLow = CoreUtilities.toLowerCase(keyword)).startsWith("regex:")) {
                        Pattern pattern = Pattern.compile(keyword.substring(6));
                        Matcher m = pattern.matcher(message);
                        if (!m.find()) continue;
                        id = entry.getKey();
                        replacementText = triggerText.replace(matcher.group(), m.group());
                        context.put("keyword", new ElementTag(m.group()));
                        if (replace == null) break block0;
                        replacementText = replace;
                        break block0;
                    }
                    if (keyword.contains("|")) {
                        for (String subkeyword : CoreUtilities.split(keyword, '|')) {
                            if (!messageLow.contains(CoreUtilities.toLowerCase(subkeyword))) continue;
                            id = entry.getKey();
                            replacementText = triggerText.replace(matcher.group(), subkeyword);
                            context.put("keyword", new ElementTag(subkeyword));
                            if (replace == null) break block0;
                            replacementText = replace;
                            break block0;
                        }
                        continue;
                    }
                    if (keyword.equals("*")) {
                        id = entry.getKey();
                        replacementText = triggerText.replace("/*/", message);
                        if (replace == null) break block0;
                        replacementText = replace;
                        break block0;
                    }
                    if (keywordLow.startsWith("strict:") && messageLow.equals(keywordLow.substring("strict:".length()))) {
                        id = entry.getKey();
                        replacementText = triggerText.replace(matcher.group(), keyword.substring("strict:".length()));
                        if (replace == null) break block0;
                        replacementText = replace;
                        break block0;
                    }
                    if (!messageLow.contains(keywordLow)) continue;
                    id = entry.getKey();
                    replacementText = triggerText.replace(matcher.group(), keyword);
                    if (replace == null) break block0;
                    replacementText = replace;
                    break block0;
                }
            }
        }
        String showNormalChat = script.getString("STEPS." + step + ".CHAT TRIGGER." + id + ".SHOW AS NORMAL CHAT", "false");
        if (id != null) {
            String hideTriggerMessage = script.getString("STEPS." + step + ".CHAT TRIGGER." + id + ".HIDE TRIGGER MESSAGE", "false");
            if (!hideTriggerMessage.equalsIgnoreCase("true")) {
                Utilities.talkToNPC(replacementText, denizenPlayer, npc, Settings.chatToNpcOverhearingRange(), new ScriptTag(script));
            }
            this.parse(npc, denizenPlayer, script, id, context);
            if (CoreConfiguration.debugVerbose) {
                Debug.log("chat to NPC");
            }
            if (!showNormalChat.equalsIgnoreCase("true")) {
                returnable.triggered = true;
            }
            return;
        }
        if (!Settings.chatGloballyIfFailedChatTriggers()) {
            Utilities.talkToNPC(message, denizenPlayer, npc, Settings.chatToNpcOverhearingRange(), new ScriptTag(script));
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Chat globally");
            }
            if (!showNormalChat.equalsIgnoreCase("true")) {
                returnable.triggered = true;
            }
            return;
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Finished calculating");
        }
        returnable.changed_text = message;
    }

    @EventHandler
    public void asyncChatTrigger(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!Settings.chatAsynchronous()) {
            return;
        }
        if (!event.isAsynchronous()) {
            this.syncChatTrigger(new PlayerChatEvent(event.getPlayer(), event.getMessage(), event.getFormat(), event.getRecipients()));
            return;
        }
        FutureTask<ChatContext> futureTask = new FutureTask<ChatContext>(() -> this.process(event.getPlayer(), event.getMessage()));
        Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), futureTask);
        try {
            ChatContext context = futureTask.get();
            if (context.wasTriggered()) {
                event.setCancelled(true);
            }
            if (context.hasChanges()) {
                event.setMessage(context.getChanges());
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    @EventHandler
    public void syncChatTrigger(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (Settings.chatAsynchronous()) {
            return;
        }
        ChatContext chat = this.process(event.getPlayer(), event.getMessage());
        if (chat.wasTriggered()) {
            event.setCancelled(true);
        }
        if (chat.hasChanges()) {
            event.setMessage(chat.getChanges());
        }
    }

    public static class ChatContext {
        String changed_text;
        boolean triggered;

        public ChatContext(boolean triggered) {
            this.triggered = triggered;
        }

        public ChatContext(String changed_text, boolean triggered) {
            this.changed_text = changed_text;
            this.triggered = triggered;
        }

        public boolean hasChanges() {
            return this.changed_text != null;
        }

        public String getChanges() {
            return this.changed_text != null ? this.changed_text : DetermineCommand.DETERMINE_NONE;
        }

        public boolean wasTriggered() {
            return this.triggered;
        }
    }
}

