/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;

public class NotedAreaTracker {
    public static HashMap<String, PerWorldSet> worlds = new HashMap();

    public static void add(AreaContainmentObject area) {
        String worldName = CoreUtilities.toLowerCase(area.getWorld().getName());
        PerWorldSet set = worlds.get(worldName);
        if (set == null) {
            set = new PerWorldSet();
            worlds.put(worldName, set);
        }
        TrackedArea tracker = new TrackedArea(area);
        AreaSet areaSet = set.bestSetFor(tracker, true);
        areaSet.list.add(tracker);
    }

    public static void remove(AreaContainmentObject area) {
        String worldName = CoreUtilities.toLowerCase(area.getWorld().getName());
        PerWorldSet set = worlds.get(worldName);
        if (set == null) {
            return;
        }
        TrackedArea tracker = new TrackedArea(area);
        AreaSet areaSet = set.bestSetFor(tracker, false);
        if (areaSet == null) {
            return;
        }
        areaSet.list.remove(tracker);
        if (areaSet.isEmpty()) {
            set.remove(areaSet);
            if (set.isEmpty()) {
                worlds.remove(worldName);
            }
        }
    }

    public static void forEachAreaInSetThatContains(int x, int z, LocationTag location, AreaSet set, Consumer<AreaContainmentObject> action) {
        if (set == null) {
            return;
        }
        for (TrackedArea area : set.list) {
            if (!area.mightContain(x, z) || !area.area.doesContainLocation(location)) continue;
            action.accept(area.area);
        }
    }

    public static void forEachAreaThatContains(LocationTag location, Consumer<AreaContainmentObject> action) {
        int x = location.getBlockX();
        int z = location.getBlockZ();
        PerWorldSet set = worlds.get(CoreUtilities.toLowerCase(location.getWorldName()));
        if (set == null) {
            return;
        }
        NotedAreaTracker.forEachAreaInSetThatContains(x, z, location, set.globalSet, action);
        NotedAreaTracker.forEachAreaInSetThatContains(x, z, location, (AreaSet)set.sets50.get(PerWorldSet.getIndex(x, z, 50, 0)), action);
        NotedAreaTracker.forEachAreaInSetThatContains(x, z, location, (AreaSet)set.sets50_offset.get(PerWorldSet.getIndex(x, z, 50, 25)), action);
        NotedAreaTracker.forEachAreaInSetThatContains(x, z, location, (AreaSet)set.sets200.get(PerWorldSet.getIndex(x, z, 200, 0)), action);
        NotedAreaTracker.forEachAreaInSetThatContains(x, z, location, (AreaSet)set.sets200_offset.get(PerWorldSet.getIndex(x, z, 200, 100)), action);
    }

    public static final class PerWorldSet {
        public final AreaSet globalSet = new AreaSet(0, 0);
        public final Int2ObjectOpenHashMap<AreaSet> sets50 = new Int2ObjectOpenHashMap();
        public final Int2ObjectOpenHashMap<AreaSet> sets50_offset = new Int2ObjectOpenHashMap();
        public final Int2ObjectOpenHashMap<AreaSet> sets200 = new Int2ObjectOpenHashMap();
        public final Int2ObjectOpenHashMap<AreaSet> sets200_offset = new Int2ObjectOpenHashMap();

        public static boolean doesFit(TrackedArea area, int scale, int offset) {
            int lowX = (area.lowX + offset) / scale;
            int lowZ = (area.lowZ + offset) / scale;
            int highX = (area.highX + offset) / scale;
            int highZ = (area.highZ + offset) / scale;
            return lowX == highX && lowZ == highZ;
        }

        public static int getIndex(int x, int z, int scale, int offset) {
            int cleanX = (x + offset) / scale;
            int cleanZ = (z + offset) / scale;
            return cleanX + (cleanZ << 16);
        }

        public AreaSet getOrGenSetFor(Int2ObjectOpenHashMap<AreaSet> sets, int type, TrackedArea area, int scale, int offset, boolean generate) {
            int index = PerWorldSet.getIndex(area.lowX, area.lowZ, scale, offset);
            AreaSet set = (AreaSet)sets.get(index);
            if (set == null && generate) {
                set = new AreaSet(type, index);
                sets.put(index, (Object)set);
            }
            return set;
        }

        public AreaSet bestSetFor(TrackedArea area, boolean generate) {
            if (PerWorldSet.doesFit(area, 50, 0)) {
                return this.getOrGenSetFor(this.sets50, 1, area, 50, 0, generate);
            }
            if (PerWorldSet.doesFit(area, 50, 25)) {
                return this.getOrGenSetFor(this.sets50_offset, 2, area, 50, 25, generate);
            }
            if (PerWorldSet.doesFit(area, 200, 0)) {
                return this.getOrGenSetFor(this.sets200, 3, area, 200, 0, generate);
            }
            if (PerWorldSet.doesFit(area, 200, 100)) {
                return this.getOrGenSetFor(this.sets200_offset, 4, area, 200, 100, generate);
            }
            return this.globalSet;
        }

        public boolean isEmpty() {
            return this.globalSet.isEmpty() && this.sets50.isEmpty() && this.sets50_offset.isEmpty() && this.sets200.isEmpty() && this.sets200_offset.isEmpty();
        }

        public void remove(AreaSet set) {
            switch (set.type) {
                case 1: {
                    this.sets50.remove(set.index);
                    break;
                }
                case 2: {
                    this.sets50_offset.remove(set.index);
                    break;
                }
                case 3: {
                    this.sets200.remove(set.index);
                    break;
                }
                case 4: {
                    this.sets200_offset.remove(set.index);
                }
            }
        }
    }

    public static final class TrackedArea {
        public final AreaContainmentObject area;
        public final int lowX;
        public final int lowZ;
        public final int highX;
        public final int highZ;

        public TrackedArea(AreaContainmentObject area) {
            CuboidTag boundary = area.getCuboidBoundary();
            LocationTag low = boundary.getLow(0);
            LocationTag high = boundary.getHigh(0);
            this.area = area;
            this.lowX = low.getBlockX();
            this.lowZ = low.getBlockZ();
            this.highX = high.getBlockX();
            this.highZ = high.getBlockZ();
        }

        public boolean mightContain(int x, int z) {
            return x >= this.lowX && x <= this.highX && z >= this.lowZ && z <= this.highZ;
        }

        public int hashCode() {
            return this.area.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof TrackedArea)) {
                return false;
            }
            TrackedArea compareTo = (TrackedArea)other;
            return this.lowX == compareTo.lowX && this.lowZ == compareTo.lowZ && this.highX == compareTo.highX && this.highZ == compareTo.highZ && this.area.equals(compareTo.area);
        }
    }

    public static final class AreaSet {
        public final ArrayList<TrackedArea> list = new ArrayList();
        public final int index;
        public final int type;

        public AreaSet(int type, int index) {
            this.type = type;
            this.index = index;
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

