/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ExCommandHelper {
    public static final Map<Object, TimedQueue> sustainedQueues = new HashMap<Object, TimedQueue>();

    public static ScriptQueue runString(String id, String command, ScriptEntryData data, Consumer<ScriptQueue> configure) {
        if (data == null) {
            data = DenizenCore.implementation.getEmptyScriptEntryData();
        }
        InstantQueue queue = new InstantQueue(id);
        queue.addEntries(ScriptBuilder.buildScriptEntries(Collections.singletonList(command), null, data));
        if (configure != null) {
            configure.accept(queue);
        }
        queue.start(true);
        return queue;
    }

    public static ScriptQueue runStringSustained(Object source, String id, String command, ScriptEntryData data, Consumer<ScriptQueue> configure) {
        TimedQueue queue;
        if (data == null) {
            data = DenizenCore.implementation.getEmptyScriptEntryData();
        }
        if ((queue = sustainedQueues.get(source)) == null || queue.isStopped) {
            queue = new TimedQueue(id);
            queue.waitWhenEmpty = true;
            sustainedQueues.put(source, queue);
        }
        queue.addEntries(ScriptBuilder.buildScriptEntries(Collections.singletonList(command), null, data));
        if (configure != null) {
            configure.accept(queue);
        }
        if (!queue.is_started) {
            queue.start(true);
        } else {
            queue.onStart();
        }
        return queue;
    }

    public static boolean removeSustainedQueue(Object source) {
        ScriptQueue queue = sustainedQueues.remove(source);
        return queue != null && !queue.isStopped;
    }
}

