/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_16.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockBase;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.Fluid;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.Material;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.TileEntitySkull;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_16_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftSkull;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get("tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get("snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get("profile");
    public static final Field BLOCK_MATERIAL = ReflectionHelper.getFields(BlockBase.class).get("material");
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetter(Material.class, "T");
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetter(BlockBase.BlockData.class, "strength");

    @Override
    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void applyPhysics(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().applyPhysics(pos, CraftMagicNumbers.getBlock((org.bukkit.Material)location.getBlock().getType()));
    }

    public <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
            return null;
        }
    }

    @Override
    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)this.getTE((CraftSkull)skull)).gameProfile;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    @Override
    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        skull.update();
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (te != null) {
            NBTTagCompound compound = new NBTTagCompound();
            te.save(compound);
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    @Override
    public void setNbtData(org.bukkit.block.Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos);
        te.load(((CraftBlockData)block.getBlockData()).getState(), ((CompoundTagImpl)ctag).toNMSTag());
    }

    @Override
    public boolean setBlockResistance(org.bukkit.Material material, float resistance) {
        Block block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(BlockBase.class, "durability", block, Float.valueOf(resistance));
        return true;
    }

    @Override
    public float getBlockResistance(org.bukkit.Material material) {
        Block block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(BlockBase.class, "durability", block)).floatValue();
    }

    @Override
    public BlockState generateBlockState(org.bukkit.block.Block block, org.bukkit.Material mat) {
        CraftBlockState state = new CraftBlockState(block);
        state.setData(CraftMagicNumbers.getBlock((org.bukkit.Material)mat).getBlockData());
        return state;
    }

    public Block getMaterialBlock(org.bukkit.Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().getBlock();
    }

    public Material getInternalMaterial(org.bukkit.Material bukkitMaterial) {
        try {
            return (Material)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public String getPushReaction(org.bukkit.Material mat) {
        return this.getInternalMaterial(mat).getPushReaction().name();
    }

    @Override
    public void setPushReaction(org.bukkit.Material mat, String reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), EnumPistonReaction.valueOf((String)reaction));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public float getBlockStrength(org.bukkit.Material mat) {
        return this.getMaterialBlock((org.bukkit.Material)mat).getBlockData().strength;
    }

    @Override
    public void setBlockStrength(org.bukkit.Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat).getBlockData(), strength);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void doRandomTick(Location location) {
        Fluid fluid;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Chunk nmsChunk = ((CraftChunk)location.getChunk()).getHandle();
        IBlockData nmsBlock = nmsChunk.getType(pos);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.isTicking()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.random);
        }
        if ((fluid = nmsBlock.getFluid()).f()) {
            fluid.b((World)nmsWorld, pos, nmsWorld.random);
        }
    }
}

