/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.npc.speech.DenizenSpeechContext;
import com.denizenscript.denizen.npc.speech.DenizenSpeechController;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.entity.Entity;

public class ChatCommand
extends AbstractCommand {
    public ChatCommand() {
        this.setName("chat");
        this.setSyntax("chat [<text>] (no_target/targets:<entity>|...) (talkers:<entity>|...) (range:<#.#>)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
        this.addRemappedPrefixes("targets", "target", "t");
        this.addRemappedPrefixes("talkers", "talker");
        this.addRemappedPrefixes("range", "r");
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="message") @ArgLinear String message, @ArgName(value="talkers") @ArgPrefixed @ArgDefaultNull ListTag talkers, @ArgName(value="targets") @ArgPrefixed @ArgDefaultNull ListTag targets, @ArgName(value="no_target") boolean noTarget, @ArgName(value="range") @ArgPrefixed @ArgDefaultText(value="-1") double chatRange) {
        if (targets == null) {
            targets = new ListTag();
            if (!noTarget) {
                PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
                if (player == null) {
                    throw new InvalidArgumentsRuntimeException("Missing targets!");
                }
                if (!player.isOnline()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Player is not online, skipping.");
                    return;
                }
                targets.addObject(player);
            }
        }
        if (talkers == null) {
            talkers = new ListTag();
            NPCTag talker = Utilities.getEntryNPC(scriptEntry);
            if (talker == null) {
                throw new InvalidArgumentsRuntimeException("Missing talker!");
            }
            talkers.addObject(talker);
        }
        if (chatRange == -1.0) {
            chatRange = Settings.chatBystandersRange();
        }
        DenizenSpeechContext context = new DenizenSpeechContext(message, scriptEntry, chatRange);
        if (!targets.isEmpty()) {
            for (EntityTag ent : targets.filter(EntityTag.class, scriptEntry)) {
                context.addRecipient(ent.getBukkitEntity());
            }
        }
        for (EntityTag talker : talkers.filter(EntityTag.class, scriptEntry)) {
            Entity entity = talker.getBukkitEntity();
            if (entity != null) {
                context.setTalker(entity);
                new DenizenSpeechController(entity).speak(context);
                continue;
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Chat Talker is not spawned! Cannot talk.");
        }
    }
}

