/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Art;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;

public class EntityPainting
implements Property {
    public static final String[] handledTags = new String[]{"painting_width", "painting_height", "painting"};
    public static final String[] handledMechs = new String[]{"painting"};
    EntityTag painting;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntityType() == EntityType.PAINTING;
    }

    public static EntityPainting getFrom(ObjectTag entity) {
        if (!EntityPainting.describes(entity)) {
            return null;
        }
        return new EntityPainting((EntityTag)entity);
    }

    private EntityPainting(EntityTag entity) {
        this.painting = entity;
    }

    @Override
    public String getPropertyString() {
        return ((Painting)this.painting.getBukkitEntity()).getArt().name();
    }

    @Override
    public String getPropertyId() {
        return "painting";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("painting_width")) {
            return new ElementTag(((Painting)this.painting.getBukkitEntity()).getArt().getBlockWidth()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("painting_height")) {
            return new ElementTag(((Painting)this.painting.getBukkitEntity()).getArt().getBlockHeight()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("painting")) {
            return new ElementTag((Enum<?>)((Painting)this.painting.getBukkitEntity()).getArt()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("painting") && mechanism.requireEnum(Art.class)) {
            Art art = Art.valueOf((String)mechanism.getValue().asString().toUpperCase());
            if (((Painting)this.painting.getBukkitEntity()).getArt() != art) {
                ((Painting)this.painting.getBukkitEntity()).setArt(art, true);
            }
        }
    }
}

