/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;

public class PlayerRaiseLowerItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static final EnumSet<Material> raisableItems = EnumSet.of(Material.SHIELD, Material.CROSSBOW, Material.BOW, Material.TRIDENT, Material.SPYGLASS);
    public static PlayerRaiseLowerItemScriptEvent instance;
    public PlayerTag player;
    public boolean state;
    public ItemTag item;
    public boolean enabled = false;
    public static Set<UUID> raisedItems;

    public PlayerRaiseLowerItemScriptEvent() {
        this.registerCouldMatcher("player raises|lowers|toggles <item>");
        instance = this;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String action = path.eventArgLowerAt(1);
        if (action.equals("raises") && !this.state) {
            return false;
        }
        if (action.equals("lowers") && this.state) {
            return false;
        }
        if (!this.runInCheck(path, this.player.getLocation())) {
            return false;
        }
        if (!path.tryArgObject(2, this.item)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "state" -> new ElementTag(this.state);
            default -> super.getContext(name);
        };
    }

    @Override
    public void init() {
        NetworkInterceptHelper.enable();
        this.enabled = true;
        super.init();
    }

    @Override
    public void destroy() {
        this.enabled = false;
        super.destroy();
    }

    public void run(Player pl) {
        this.cancelled = false;
        this.player = new PlayerTag(pl);
        this.item = raisableItems.contains(this.player.getHeldItem().getBukkitMaterial()) || !raisableItems.contains(this.player.getOffhandItem().getBukkitMaterial()) ? this.player.getHeldItem() : this.player.getOffhandItem();
        this.fire();
    }

    public static void signalDidRaise(Player player) {
        if (!raisedItems.add(player.getUniqueId())) {
            return;
        }
        PlayerRaiseLowerItemScriptEvent.instance.state = true;
        instance.run(player);
    }

    public static void signalDidLower(Player player) {
        if (!raisedItems.remove(player.getUniqueId())) {
            return;
        }
        PlayerRaiseLowerItemScriptEvent.instance.state = false;
        instance.run(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerRaiseLowerItemScriptEvent.signalDidLower(event.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        PlayerRaiseLowerItemScriptEvent.signalDidLower(event.getEntity());
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        PlayerRaiseLowerItemScriptEvent.signalDidLower(event.getPlayer());
    }

    static {
        raisedItems = new HashSet<UUID>();
    }

    public static class PlayerRaiseLowerItemScriptEventSpigotImpl
    extends PlayerRaiseLowerItemScriptEvent {
        @EventHandler
        public void onPlayerDropItem(PlayerDropItemEvent event) {
            PlayerRaiseLowerItemScriptEventSpigotImpl.signalDidLower(event.getPlayer());
        }

        @EventHandler
        public void onPlayerChangeHeldItem(PlayerItemHeldEvent event) {
            PlayerRaiseLowerItemScriptEventSpigotImpl.signalDidLower(event.getPlayer());
        }
    }
}

