/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.nbt;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.DoubleTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.IntTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.LongTag;
import com.denizenscript.denizen.nms.util.jnbt.StringTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.properties.entity.EntityDisabledSlots;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CustomNBT {
    public static final String KEY_DENIZEN = "Denizen NBT";
    public static final String KEY_ATTRIBUTES = "AttributeModifiers";
    public static final String KEY_CAN_PLACE_ON = "CanPlaceOn";
    public static final String KEY_CAN_DESTROY = "CanDestroy";
    public static final String KEY_DISABLED_SLOTS = "DisabledSlots";
    private static final Map<EquipmentSlot, Integer> slotMap = new HashMap<EquipmentSlot, Integer>();
    public static final AsciiMatcher uppercaseMatcher;
    public static final HashMap<String, String> attributeNameUpdates;

    public static List<AttributeReturn> getAttributes(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        ArrayList<CompoundTag> attribs = new ArrayList<CompoundTag>();
        if (compoundTag.getValue().containsKey(KEY_ATTRIBUTES)) {
            List temp = (List)((Tag)compoundTag.getValue().get(KEY_ATTRIBUTES)).getValue();
            for (Tag tag : temp) {
                attribs.add((CompoundTag)tag);
            }
        }
        ArrayList<AttributeReturn> attrs = new ArrayList<AttributeReturn>();
        for (int i = 0; i < attribs.size(); ++i) {
            CompoundTag ct = (CompoundTag)attribs.get(i);
            AttributeReturn atr = new AttributeReturn();
            atr.attr = (String)((Tag)ct.getValue().get("Name")).getValue();
            atr.slot = ct.getValue().get("Slot") == null ? "mainhand" : (String)((Tag)ct.getValue().get("Slot")).getValue();
            atr.op = (Integer)((Tag)ct.getValue().get("Operation")).getValue();
            Tag t = (Tag)ct.getValue().get("Amount");
            atr.amt = t instanceof IntTag ? (double)((Integer)t.getValue()).intValue() : (t instanceof LongTag ? (double)((Long)t.getValue()).longValue() : (t instanceof DoubleTag ? (Double)t.getValue() : 0.0));
            if (ct.getValue().containsKey("UUID")) {
                UUID id = NMSHandler.itemHelper.convertNbtToUuid((IntArrayTag)ct.getValue().get("UUID"));
                atr.uuidLeast = id.getLeastSignificantBits();
                atr.uuidMost = id.getMostSignificantBits();
            } else if (ct.getValue().containsKey("UUIDMost")) {
                t = (Tag)ct.getValue().get("UUIDMost");
                if (t instanceof LongTag) {
                    atr.uuidMost = (Long)t.getValue();
                } else if (t instanceof IntTag) {
                    atr.uuidMost = ((Integer)t.getValue()).intValue();
                }
                t = (Tag)ct.getValue().get("UUIDLeast");
                if (t instanceof LongTag) {
                    atr.uuidLeast = (Long)t.getValue();
                } else if (t instanceof IntTag) {
                    atr.uuidLeast = ((Integer)t.getValue()).intValue();
                }
            }
            attrs.add(atr);
        }
        return attrs;
    }

    public static long uuidChoice(ItemStack its) {
        String mat = CoreUtilities.toLowerCase(its.getType().name());
        if (mat.contains("boots")) {
            return 1000L;
        }
        if (mat.contains("legging")) {
            return 100000L;
        }
        if (mat.contains("helmet")) {
            return 10000000L;
        }
        if (mat.contains("chestp")) {
            return 1000000000L;
        }
        return 1L;
    }

    public static String fixAttributeName1_16(String input) {
        if (!uppercaseMatcher.containsAnyMatch(input)) {
            return input;
        }
        String replacement = attributeNameUpdates.get(input);
        if (replacement != null) {
            return replacement;
        }
        return CoreUtilities.toLowerCase(input);
    }

    public static ItemStack addAttribute(ItemStack itemStack, String attr, String slot, int op, double amt) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        ArrayList<CompoundTag> attribs = new ArrayList<CompoundTag>();
        if (compoundTag.getValue().containsKey(KEY_ATTRIBUTES)) {
            List temp = (List)((Tag)compoundTag.getValue().get(KEY_ATTRIBUTES)).getValue();
            for (Tag tag : temp) {
                attribs.add((CompoundTag)tag);
            }
        }
        HashMap<String, Tag> tmap = new HashMap<String, Tag>();
        attr = CustomNBT.fixAttributeName1_16(attr);
        tmap.put("AttributeName", new StringTag(attr));
        tmap.put("Name", new StringTag(attr));
        tmap.put("Slot", new StringTag(slot));
        tmap.put("Operation", new IntTag(op));
        tmap.put("Amount", new DoubleTag(amt));
        long uuidhelp = CustomNBT.uuidChoice(itemStack);
        UUID fullUuid = new UUID(uuidhelp + 88512L + (long)attribs.size(), uuidhelp * 2L + 1250025L + (long)attribs.size());
        tmap.put("UUID", NMSHandler.itemHelper.convertUuidToNbt(fullUuid));
        CompoundTag ct = NMSHandler.instance.createCompoundTag(tmap);
        attribs.add(ct);
        JNBTListTag lt = new JNBTListTag(CompoundTag.class, attribs);
        compoundTag = compoundTag.createBuilder().put(KEY_ATTRIBUTES, lt).build();
        return NMSHandler.itemHelper.setNbtData(itemStack, compoundTag);
    }

    public static List<Material> getNBTMaterials(ItemStack itemStack, String key) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        ArrayList<Material> materials = new ArrayList<Material>();
        if (compoundTag.getValue().containsKey(key)) {
            List temp = (List)((Tag)compoundTag.getValue().get(key)).getValue();
            for (StringTag tag : temp) {
                materials.add(Material.matchMaterial((String)tag.getValue()));
            }
        }
        return materials;
    }

    public static ItemStack setNBTMaterials(ItemStack itemStack, String key, List<Material> materials) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        compoundTag = compoundTag.createBuilder().remove(key).build();
        if (materials.isEmpty()) {
            return NMSHandler.itemHelper.setNbtData(itemStack, compoundTag);
        }
        ArrayList<StringTag> internalMaterials = new ArrayList<StringTag>();
        for (Material material : materials) {
            internalMaterials.add(new StringTag(material.getKey().toString()));
        }
        JNBTListTag lt = new JNBTListTag(StringTag.class, internalMaterials);
        compoundTag = compoundTag.createBuilder().put(key, lt).build();
        return NMSHandler.itemHelper.setNbtData(itemStack, compoundTag);
    }

    public static ItemStack addCustomNBT(ItemStack itemStack, String key, String value, String basekey) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        CompoundTag denizenTag = compoundTag.getValue().containsKey(basekey) ? (CompoundTag)compoundTag.getValue().get(basekey) : NMSHandler.instance.createCompoundTag(new HashMap<String, Tag>());
        denizenTag = denizenTag.createBuilder().putString(CoreUtilities.toLowerCase(key), value).build();
        compoundTag = compoundTag.createBuilder().put(basekey, denizenTag).build();
        return NMSHandler.itemHelper.setNbtData(itemStack, compoundTag);
    }

    public static ItemStack clearNBT(ItemStack itemStack, String key) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        compoundTag = compoundTag.createBuilder().remove(key).build();
        return NMSHandler.itemHelper.setNbtData(itemStack, compoundTag);
    }

    public static ItemStack removeCustomNBT(ItemStack itemStack, String key, String basekey) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        if (!compoundTag.getValue().containsKey(basekey)) {
            return itemStack;
        }
        CompoundTag denizenTag = (CompoundTag)compoundTag.getValue().get(basekey);
        denizenTag = denizenTag.createBuilder().remove(CoreUtilities.toLowerCase(key)).build();
        compoundTag = denizenTag.getValue().isEmpty() ? compoundTag.createBuilder().remove(basekey).build() : compoundTag.createBuilder().put(basekey, denizenTag).build();
        return NMSHandler.itemHelper.setNbtData(itemStack, compoundTag);
    }

    public static boolean hasCustomNBT(ItemStack itemStack, String key, String basekey) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        if (!compoundTag.getValue().containsKey(basekey)) {
            return false;
        }
        CompoundTag denizenTag = (CompoundTag)compoundTag.getValue().get(basekey);
        return denizenTag.getValue().containsKey(CoreUtilities.toLowerCase(key));
    }

    public static String getCustomNBT(ItemStack itemStack, String key, String basekey) {
        String lowerKey;
        CompoundTag denizenTag;
        if (itemStack == null || itemStack.getType() == Material.AIR || key == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        if (compoundTag.getValue().containsKey(basekey) && (denizenTag = (CompoundTag)compoundTag.getValue().get(basekey)).containsKey(lowerKey = CoreUtilities.toLowerCase(key))) {
            return denizenTag.getString(lowerKey);
        }
        return null;
    }

    public static List<String> listNBT(ItemStack itemStack, String basekey) {
        ArrayList<String> nbt = new ArrayList<String>();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return nbt;
        }
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(itemStack);
        if (compoundTag.getValue().containsKey(basekey)) {
            CompoundTag denizenTag = (CompoundTag)compoundTag.getValue().get(basekey);
            nbt.addAll(denizenTag.getValue().keySet());
        }
        return nbt;
    }

    public static void addCustomNBT(Entity entity, String key, String value) {
        if (entity == null) {
            return;
        }
        CompoundTag compoundTag = NMSHandler.entityHelper.getNbtData(entity);
        compoundTag = compoundTag.createBuilder().putString(key, value).build();
        NMSHandler.entityHelper.setNbtData(entity, compoundTag);
    }

    public static void addCustomNBT(Entity entity, String key, int value) {
        if (entity == null) {
            return;
        }
        CompoundTag compoundTag = NMSHandler.entityHelper.getNbtData(entity);
        compoundTag = compoundTag.createBuilder().putInt(key, value).build();
        NMSHandler.entityHelper.setNbtData(entity, compoundTag);
    }

    public static void removeCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return;
        }
        CompoundTag compoundTag = NMSHandler.entityHelper.getNbtData(entity);
        compoundTag = compoundTag.createBuilder().remove(key).build();
        NMSHandler.entityHelper.setNbtData(entity, compoundTag);
    }

    public static boolean hasCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return false;
        }
        CompoundTag compoundTag = NMSHandler.entityHelper.getNbtData(entity);
        return compoundTag.getValue().containsKey(key);
    }

    public static String getCustomNBT(Entity entity, String key) {
        if (entity == null) {
            return null;
        }
        CompoundTag compoundTag = NMSHandler.entityHelper.getNbtData(entity);
        return compoundTag.getString(key);
    }

    public static int getCustomIntNBT(Entity entity, String key) {
        if (entity == null) {
            return 0;
        }
        CompoundTag compoundTag = NMSHandler.entityHelper.getNbtData(entity);
        return compoundTag.getInt(key);
    }

    public static void setDisabledSlots(Entity entity, Map<EquipmentSlot, Set<EntityDisabledSlots.Action>> map) {
        int sum = 0;
        for (Map.Entry<EquipmentSlot, Set<EntityDisabledSlots.Action>> entry : map.entrySet()) {
            if (!slotMap.containsKey(entry.getKey())) continue;
            for (EntityDisabledSlots.Action action : entry.getValue()) {
                sum += 1 << slotMap.get(entry.getKey()) + action.getId();
            }
        }
        CustomNBT.addCustomNBT(entity, KEY_DISABLED_SLOTS, sum);
    }

    public static Map<EquipmentSlot, Set<EntityDisabledSlots.Action>> getDisabledSlots(Entity entity) {
        if (entity == null) {
            return null;
        }
        HashMap<EquipmentSlot, Set<EntityDisabledSlots.Action>> map = new HashMap<EquipmentSlot, Set<EntityDisabledSlots.Action>>();
        CompoundTag compoundTag = NMSHandler.entityHelper.getNbtData(entity);
        int disabledSlots = compoundTag.getInt(KEY_DISABLED_SLOTS);
        if (disabledSlots == 0) {
            return map;
        }
        block0: for (EquipmentSlot slot : slotMap.keySet()) {
            for (EntityDisabledSlots.Action action : EntityDisabledSlots.Action.values()) {
                int matchedSlot = disabledSlots & 1 << slotMap.get(slot) + action.getId();
                if (matchedSlot == 0) continue;
                Set set = map.computeIfAbsent(slot, k -> new HashSet());
                set.add(action);
                if ((disabledSlots -= matchedSlot) == 0) break block0;
            }
        }
        return map;
    }

    static {
        slotMap.put(EquipmentSlot.HAND, 0);
        slotMap.put(EquipmentSlot.FEET, 1);
        slotMap.put(EquipmentSlot.LEGS, 2);
        slotMap.put(EquipmentSlot.CHEST, 3);
        slotMap.put(EquipmentSlot.HEAD, 4);
        slotMap.put(EquipmentSlot.OFF_HAND, 5);
        uppercaseMatcher = new AsciiMatcher("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        attributeNameUpdates = new HashMap();
        attributeNameUpdates.put("generic.maxHealth", "generic.max_health");
        attributeNameUpdates.put("generic.followRange", "generic.follow_range");
        attributeNameUpdates.put("generic.knockbackResistance", "generic.knockback_resistance");
        attributeNameUpdates.put("generic.movementSpeed", "generic.movement_speed");
        attributeNameUpdates.put("generic.flyingSpeed", "generic.flying_speed");
        attributeNameUpdates.put("generic.attackDamage", "generic.attack_damage");
        attributeNameUpdates.put("generic.attackKnockback", "generic.attack_knockback");
        attributeNameUpdates.put("generic.attackSpeed", "generic.attack_speed");
        attributeNameUpdates.put("generic.armorToughness", "generic.armor_toughness");
    }

    public static class AttributeReturn {
        public String attr;
        public String slot;
        public int op;
        public double amt;
        public long uuidMost;
        public long uuidLeast;
    }
}

