/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;

public class EntityAI
implements Property {
    public static final String[] handledMechs = new String[]{"has_ai", "toggle_ai"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).isLivingEntity();
    }

    public static EntityAI getFrom(ObjectTag entity) {
        if (!EntityAI.describes(entity)) {
            return null;
        }
        return new EntityAI((EntityTag)entity);
    }

    private EntityAI(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.entity.getLivingEntity().hasAI());
    }

    @Override
    public String getPropertyId() {
        return "has_ai";
    }

    public static void register() {
        PropertyParser.registerTag(EntityAI.class, ElementTag.class, "has_ai", (attribute, object) -> new ElementTag(object.entity.getLivingEntity().hasAI()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("has_ai") || mechanism.matches("toggle_ai")) && mechanism.requireBoolean()) {
            this.entity.getLivingEntity().setAI(mechanism.getValue().asBoolean());
        }
    }
}

