/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PluginTag
implements ObjectTag,
FlaggableObject {
    private Plugin plugin;
    private String prefix = "Plugin";
    public static ObjectTagProcessor<PluginTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static PluginTag valueOf(String string) {
        return PluginTag.valueOf(string, null);
    }

    @Fetchable(value="pl")
    public static PluginTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = CoreUtilities.toLowerCase(string).replace("pl@", "");
        try {
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                if (!string.equalsIgnoreCase(plugin.getName())) continue;
                return new PluginTag(plugin);
            }
        }
        catch (Exception e) {
            Debug.echoError("Invalid plugin name specified, or plugin is not enabled: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (CoreUtilities.toLowerCase(arg).startsWith("pl@")) {
            return true;
        }
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            if (!arg.equalsIgnoreCase(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    public PluginTag(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "pl@" + this.plugin.getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.plugin;
    }

    @Override
    public PluginTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.serverFlagMap, "__plugins." + this.plugin.getName().replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void register() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.plugin.getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "version", (attribute, object) -> new ElementTag(object.plugin.getDescription().getVersion()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "description", (attribute, object) -> new ElementTag(object.plugin.getDescription().getDescription()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "authors", (attribute, object) -> new ListTag(object.plugin.getDescription().getAuthors()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "depends", (attribute, object) -> new ListTag(object.plugin.getDescription().getDepend()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "soft_depends", (attribute, object) -> new ListTag(object.plugin.getDescription().getSoftDepend()), new String[0]);
        tagProcessor.registerTag(MapTag.class, "commands", (attribute, object) -> {
            Map commands = object.plugin.getDescription().getCommands();
            MapTag output = new MapTag();
            if (commands == null || commands.isEmpty()) {
                return output;
            }
            for (Map.Entry command : commands.entrySet()) {
                Object obj;
                MapTag dataMap = new MapTag();
                if (((Map)command.getValue()).containsKey("description")) {
                    dataMap.putObject("description", new ElementTag(((Map)command.getValue()).get("description").toString(), true));
                }
                if (((Map)command.getValue()).containsKey("usage")) {
                    dataMap.putObject("usage", new ElementTag(((Map)command.getValue()).get("usage").toString(), true));
                }
                if (((Map)command.getValue()).containsKey("permission")) {
                    dataMap.putObject("permission", new ElementTag(((Map)command.getValue()).get("permission").toString(), true));
                }
                if (((Map)command.getValue()).containsKey("aliases") && (obj = ((Map)command.getValue()).get("aliases")) instanceof List) {
                    ListTag aliases = new ListTag();
                    for (Object entry : (List)obj) {
                        aliases.addObject(new ElementTag(String.valueOf(entry), true));
                    }
                    dataMap.putObject("aliases", aliases);
                }
                output.putObject((String)command.getKey(), dataMap);
            }
            return output;
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

