/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Fireball;

public class EntityDirection
implements Property {
    public static final String[] handledMechs = new String[]{"direction"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Fireball;
    }

    public static EntityDirection getFrom(ObjectTag entity) {
        if (!EntityDirection.describes(entity)) {
            return null;
        }
        return new EntityDirection((EntityTag)entity);
    }

    private EntityDirection(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return new LocationTag(this.getFireball().getDirection()).identify();
    }

    @Override
    public String getPropertyId() {
        return "direction";
    }

    public Fireball getFireball() {
        return (Fireball)this.entity.getBukkitEntity();
    }

    public static void register() {
        PropertyParser.registerTag(EntityDirection.class, LocationTag.class, "direction", (attribute, object) -> new LocationTag(object.getFireball().getDirection()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("direction") && mechanism.requireObject(LocationTag.class)) {
            this.getFireball().setDirection(mechanism.valueAsType(LocationTag.class).toVector());
        }
    }
}

