/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityTeleportedByPortalScriptEvent
extends BukkitScriptEvent
implements Listener {
    EntityPortalReadyEvent event;

    public EntityTeleportedByPortalScriptEvent() {
        this.registerCouldMatcher("<entity> teleported by portal");
        this.registerSwitches("to", "portal_type");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryObjectSwitch("to", WorldTag.mirrorBukkitWorld(this.event.getTargetWorld()))) {
            return false;
        }
        if (!EntityTeleportedByPortalScriptEvent.runGenericSwitchCheck(path, "portal_type", this.event.getPortalType().name())) {
            return false;
        }
        if (!path.tryArgObject(0, new EntityTag(this.event.getEntity()))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> new EntityTag(this.event.getEntity());
            case "target_world" -> {
                if (this.event.getTargetWorld() != null) {
                    yield new WorldTag(this.event.getTargetWorld());
                }
                yield null;
            }
            case "portal_type" -> new ElementTag((Enum<?>)this.event.getPortalType());
            default -> super.getContext(name);
        };
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = CoreUtilities.toLowerCase(determinationObj.toString());
            if (determination.startsWith("target_world:")) {
                WorldTag world = WorldTag.valueOf(determination.substring("target_world:".length()), this.getTagContext(path));
                if (world != null) {
                    this.event.setTargetWorld(world.getWorld());
                    return true;
                }
            } else if (determination.equals("remove_target_world")) {
                this.event.setTargetWorld(null);
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @EventHandler
    public void onEntityPortalReady(EntityPortalReadyEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

