/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import io.papermc.paper.entity.Frictional;
import net.kyori.adventure.util.TriState;

public class EntityFriction
implements Property {
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        EntityTag entityTag;
        return object instanceof EntityTag && (entityTag = (EntityTag)object).getBukkitEntity() instanceof Frictional;
    }

    public static EntityFriction getFrom(ObjectTag entity) {
        if (!EntityFriction.describes(entity)) {
            return null;
        }
        return new EntityFriction((EntityTag)entity);
    }

    private EntityFriction(EntityTag ent) {
        this.entity = ent;
    }

    public Frictional getFrictional() {
        return (Frictional)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        Boolean frictionState = this.getFrictional().getFrictionState().toBoolean();
        if (frictionState == null) {
            return null;
        }
        return String.valueOf(frictionState);
    }

    @Override
    public String getPropertyId() {
        return "has_friction";
    }

    public static void register() {
        PropertyParser.registerTag(EntityFriction.class, ElementTag.class, "has_friction", (attribute, object) -> {
            Boolean frictionState = object.getFrictional().getFrictionState().toBoolean();
            if (frictionState == null) {
                return null;
            }
            return new ElementTag(frictionState);
        }, new String[0]);
        PropertyParser.registerMechanism(EntityFriction.class, ElementTag.class, "has_friction", (object, mechanism, input) -> {
            if (!mechanism.hasValue()) {
                object.getFrictional().setFrictionState(TriState.NOT_SET);
            } else if (mechanism.requireBoolean()) {
                object.getFrictional().setFrictionState(TriState.byBoolean((boolean)input.asBoolean()));
            }
        }, new String[0]);
    }
}

