/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBaseColor
implements Property {
    public static final String[] handledTags = new String[]{"base_color"};
    public static final String[] handledMechs = new String[]{"base_color"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        if (item instanceof ItemTag) {
            return ((ItemTag)item).getBukkitMaterial() == Material.SHIELD;
        }
        return false;
    }

    public static ItemBaseColor getFrom(ObjectTag item) {
        if (!ItemBaseColor.describes(item)) {
            return null;
        }
        return new ItemBaseColor((ItemTag)item);
    }

    public ItemBaseColor(ItemTag item) {
        this.item = item;
    }

    public DyeColor getBaseColor() {
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            DyeColor color = ((Banner)((BlockStateMeta)itemMeta).getBlockState()).getBaseColor();
            if (color == DyeColor.WHITE && this.item.getBukkitMaterial() == Material.SHIELD && ItemRawNBT.getFrom(this.item).getFullNBTMap().getObject("BlockEntityTag") == null) {
                return null;
            }
            return color;
        }
        return ((BannerMeta)itemMeta).getBaseColor();
    }

    public void setBaseColor(DyeColor color, TagContext context) {
        if (color == null && this.item.getBukkitMaterial() == Material.SHIELD) {
            ItemRawNBT property = ItemRawNBT.getFrom(this.item);
            MapTag nbt = property.getFullNBTMap();
            nbt.putObject("BlockEntityTag", null);
            property.setFullNBT(this.item, nbt, context, false);
            return;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            Banner banner = (Banner)((BlockStateMeta)itemMeta).getBlockState();
            banner.setBaseColor(color);
            banner.update();
            ((BlockStateMeta)itemMeta).setBlockState((BlockState)banner);
        } else {
            ((BannerMeta)itemMeta).setBaseColor(color);
        }
        this.item.setItemMeta(itemMeta);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("base_color")) {
            DyeColor baseColor = this.getBaseColor();
            if (baseColor != null) {
                return new ElementTag((Enum<?>)baseColor).getObjectAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        DyeColor baseColor = this.getBaseColor();
        if (baseColor != null) {
            return baseColor.name();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "base_color";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("base_color")) {
            this.setBaseColor(mechanism.hasValue() ? DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()) : null, mechanism.context);
        }
    }
}

