/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBaseColor
extends ItemProperty {
    public static boolean describes(ItemTag item) {
        return item.getBukkitMaterial() == Material.SHIELD;
    }

    @Override
    public String getPropertyString() {
        DyeColor baseColor = this.getBaseColor();
        if (baseColor != null) {
            return baseColor.name();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "base_color";
    }

    public DyeColor getBaseColor() {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            DyeColor color = ((Banner)((BlockStateMeta)itemMeta).getBlockState()).getBaseColor();
            if (color == DyeColor.WHITE && this.getMaterial() == Material.SHIELD && new ItemRawNBT((ItemTag)this.object).getFullNBTMap().getObject("BlockEntityTag") == null) {
                return null;
            }
            return color;
        }
        return ((BannerMeta)itemMeta).getBaseColor();
    }

    public void setBaseColor(DyeColor color, TagContext context) {
        if (color == null && this.getMaterial() == Material.SHIELD) {
            ItemRawNBT property = ItemRawNBT.getFrom(this.object);
            MapTag nbt = property.getFullNBTMap();
            nbt.putObject("BlockEntityTag", null);
            property.setFullNBT((ItemTag)this.object, nbt, context, false);
            return;
        }
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            Banner banner = (Banner)((BlockStateMeta)itemMeta).getBlockState();
            banner.setBaseColor(color);
            banner.update();
            ((BlockStateMeta)itemMeta).setBlockState((BlockState)banner);
        } else {
            ((BannerMeta)itemMeta).setBaseColor(color);
        }
        this.setItemMeta(itemMeta);
    }

    public static void register() {
        PropertyParser.registerTag(ItemBaseColor.class, ElementTag.class, "base_color", (attribute, prop) -> {
            DyeColor baseColor = prop.getBaseColor();
            if (baseColor == null) {
                return null;
            }
            return new ElementTag((Enum<?>)baseColor);
        }, new String[0]);
        PropertyParser.registerMechanism(ItemBaseColor.class, ElementTag.class, "base_color", (prop, mechanism, param) -> prop.setBaseColor(mechanism.hasValue() ? DyeColor.valueOf((String)param.asString().toUpperCase()) : null, mechanism.context), new String[0]);
    }
}

