/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.trade;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.properties.trade.TradeProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ListTag;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class TradeInputs
extends TradeProperty<ListTag> {
    public static boolean describes(TradeTag recipe) {
        return true;
    }

    @Override
    public ListTag getPropertyValue() {
        return this.getIngredientsList();
    }

    @Override
    public void setPropertyValue(ListTag inList, Mechanism mechanism) {
        List<Object> ingredients = new ArrayList<ItemStack>();
        List<ItemTag> list = inList.filter(ItemTag.class, mechanism.context);
        if (!mechanism.hasValue() || list.isEmpty()) {
            this.getRecipe().setIngredients(ingredients);
            return;
        }
        for (ItemTag item : list) {
            ingredients.add(item.getItemStack());
        }
        if (ingredients.size() > 2) {
            mechanism.echoError("Trade recipe input was given " + list.size() + " items. Only using the first two items!");
            ingredients = ingredients.subList(0, 2);
        }
        this.getRecipe().setIngredients(ingredients);
    }

    @Override
    public String getPropertyId() {
        return "inputs";
    }

    public ListTag getIngredientsList() {
        ListTag result = new ListTag();
        for (ItemStack item : this.getRecipe().getIngredients()) {
            result.addObject(new ItemTag(item));
        }
        return result;
    }

    public static void register() {
        TradeInputs.autoRegister("inputs", TradeInputs.class, ListTag.class, false, new String[0]);
    }
}

