/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_19.Handler;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_19.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_19_R3.map.CraftMapView;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;

public class PacketHelperImpl
implements PacketHelper {
    public static final DataWatcherObject<Float> PLAYER_DATA_ACCESSOR_ABSORPTION = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityHuman.class, ReflectionMappingsInfo.Player_DATA_PLAYER_ABSORPTION_ID, null);
    public static final DataWatcherObject<Byte> ENTITY_DATA_ACCESSOR_FLAGS = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.world.entity.Entity.class, ReflectionMappingsInfo.Entity_DATA_SHARED_FLAGS_ID, null);
    public static final MethodHandle ABILITIES_PACKET_FOV_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutAbilities.class, ReflectionMappingsInfo.ClientboundPlayerAbilitiesPacket_walkingSpeed);
    public static Field ENTITY_TRACKER_ENTRY_GETTER = ReflectionHelper.getFields(PlayerChunkMap.EntityTracker.class).getFirstOfType(EntityTrackerEntry.class);
    public static MethodHandle CANVAS_GET_BUFFER = ReflectionHelper.getMethodHandle(CraftMapCanvas.class, "getBuffer", new Class[0]);
    public static Field MAPVIEW_WORLDMAP = ReflectionHelper.getFields(CraftMapView.class).get("worldMap");
    public static MethodHandle BLOCK_ENTITY_DATA_PACKET_CONSTRUCTOR = ReflectionHelper.getConstructor(PacketPlayOutTileEntityData.class, BlockPosition.class, TileEntityTypes.class, NBTTagCompound.class);
    public static DataWatcherObject<Optional<IChatBaseComponent>> ENTITY_DATA_ACCESSOR_CUSTOM_NAME = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.world.entity.Entity.class, ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME, null);
    public static DataWatcherObject<Boolean> ENTITY_DATA_ACCESSOR_CUSTOM_NAME_VISIBLE = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.world.entity.Entity.class, ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME_VISIBLE, null);
    public static HashMap<UUID, HashMap<UUID, ScoreboardTeam>> noCollideTeamMap = new HashMap();

    @Override
    public void setFakeAbsorption(Player player, float value) {
        DataWatcher dw = new DataWatcher(null);
        dw.a(PLAYER_DATA_ACCESSOR_ABSORPTION, (Object)Float.valueOf(value));
        PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(player.getEntityId(), dw.b()));
    }

    @Override
    public void setSlot(Player player, int slot, ItemStack itemStack, boolean playerOnly) {
        Container menu = ((CraftPlayer)player).getHandle().bP;
        int windowId = playerOnly ? 0 : menu.j;
        PacketHelperImpl.send(player, new PacketPlayOutSetSlot(windowId, menu.k(), slot, CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    @Override
    public void setFieldOfView(Player player, float fov) {
        PacketPlayOutAbilities packet = new PacketPlayOutAbilities(((CraftPlayer)player).getHandle().fK());
        if (!Float.isNaN(fov)) {
            try {
                ABILITIES_PACKET_FOV_SETTER.invoke(packet, fov);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        PacketHelperImpl.send(player, packet);
    }

    @Override
    public void respawn(Player player) {
        ((CraftPlayer)player).getHandle().b.a(new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.a));
    }

    @Override
    public void setVision(Player player, EntityType entityType) {
        EntityCreeper entity;
        if (entityType == EntityType.CREEPER) {
            entity = new EntityCreeper(EntityTypes.u, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.SPIDER) {
            entity = new EntitySpider(EntityTypes.aS, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.CAVE_SPIDER) {
            entity = new EntityCaveSpider(EntityTypes.n, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.ENDERMAN) {
            entity = new EntityEnderman(EntityTypes.E, (World)((CraftWorld)player.getWorld()).getHandle());
        } else {
            return;
        }
        PacketHelperImpl.send(player, new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entity));
        PacketHelperImpl.send(player, new PacketPlayOutCamera((net.minecraft.world.entity.Entity)entity));
        ((CraftServer)Bukkit.getServer()).getHandle().respawn(((CraftPlayer)player).getHandle(), ((CraftWorld)player.getWorld()).getHandle(), true, player.getLocation(), false, PlayerRespawnEvent.RespawnReason.PLUGIN);
    }

    @Override
    public void showBlockAction(Player player, Location location, int action, int state) {
        BlockPosition position = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Block block = ((CraftWorld)location.getWorld()).getHandle().a_(position).b();
        PacketHelperImpl.send(player, new PacketPlayOutBlockAction(position, block, action, state));
    }

    @Override
    public void showBlockCrack(Player player, int id, Location location, int progress) {
        BlockPosition position = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        PacketHelperImpl.send(player, new PacketPlayOutBlockBreakAnimation(id, position, progress));
    }

    @Override
    public void showTileEntityData(Player player, Location location, int action, CompoundTag compoundTag) {
        BlockPosition position = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        try {
            PacketPlayOutTileEntityData packet = BLOCK_ENTITY_DATA_PACKET_CONSTRUCTOR.invoke(position, action, ((CompoundTagImpl)compoundTag).toNMSTag());
            PacketHelperImpl.send(player, packet);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void showBannerUpdate(Player player, Location location, DyeColor base, List<Pattern> patterns) {
        ArrayList<CompoundTag> nbtPatterns = new ArrayList<CompoundTag>();
        for (Pattern pattern : patterns) {
            nbtPatterns.add(NMSHandler.instance.createCompoundTag(new HashMap<String, Tag>()).createBuilder().putInt("Color", pattern.getColor().getDyeData()).putString("Pattern", pattern.getPattern().getIdentifier()).build());
        }
        CompoundTag compoundTag = NMSHandler.blockHelper.getNbtData(location.getBlock()).createBuilder().put("Patterns", new JNBTListTag(CompoundTag.class, nbtPatterns)).build();
        this.showTileEntityData(player, location, 3, compoundTag);
    }

    @Override
    public void showTabListHeaderFooter(Player player, String header, String footer) {
        IChatMutableComponent cHeader = Handler.componentToNMS(FormattedTextHelper.parse(header, ChatColor.WHITE));
        IChatMutableComponent cFooter = Handler.componentToNMS(FormattedTextHelper.parse(footer, ChatColor.WHITE));
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter((IChatBaseComponent)cHeader, (IChatBaseComponent)cFooter);
        PacketHelperImpl.send(player, packet);
    }

    @Override
    public void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketHelperImpl.send(player, new ClientboundSetTitlesAnimationPacket(fadeInTicks, stayTicks, fadeOutTicks));
        if (title != null) {
            PacketHelperImpl.send(player, new ClientboundSetTitleTextPacket((IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse(title, ChatColor.WHITE))));
        }
        if (subtitle != null) {
            PacketHelperImpl.send(player, new ClientboundSetSubtitleTextPacket((IChatBaseComponent)Handler.componentToNMS(FormattedTextHelper.parse(subtitle, ChatColor.WHITE))));
        }
    }

    @Override
    public void showHealth(Player player, float health, int food, float saturation) {
        PacketHelperImpl.send(player, new PacketPlayOutUpdateHealth(health, food, saturation));
    }

    @Override
    public void showMobHealth(Player player, LivingEntity mob, double health, double maxHealth) {
        AttributeModifiable attr = new AttributeModifiable(GenericAttributes.a, a2 -> {});
        attr.a(maxHealth);
        PacketHelperImpl.send(player, new PacketPlayOutUpdateAttributes(mob.getEntityId(), Collections.singletonList(attr)));
        PacketDataSerializer healthData = new PacketDataSerializer(Unpooled.buffer());
        healthData.d(mob.getEntityId());
        healthData.writeByte(9);
        healthData.d(2);
        healthData.writeFloat((float)health);
        healthData.writeByte(255);
        PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(healthData));
    }

    @Override
    public void resetHealth(Player player) {
        this.showHealth(player, (float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
    }

    @Override
    public void showSignEditor(Player player, Location location) {
        BlockPosition pos;
        LocationTag fakeSign = new LocationTag(player.getLocation());
        fakeSign.setY(0.0);
        FakeBlock.showFakeBlockTo(Collections.singletonList(new PlayerTag(player)), fakeSign, new MaterialTag(Material.OAK_WALL_SIGN), new DurationTag(1), true);
        DenizenNetworkManagerImpl.getNetworkManager((Player)player).packetListener.fakeSignExpected = pos = new BlockPosition(fakeSign.getBlockX(), 0, fakeSign.getBlockZ());
        PacketHelperImpl.send(player, new PacketPlayOutOpenSignEditor(pos));
    }

    @Override
    public void forceSpectate(Player player, Entity entity) {
        PacketHelperImpl.send(player, new PacketPlayOutCamera(((CraftEntity)entity).getHandle()));
    }

    public static void forceRespawnPlayerEntity(Entity entity, Player viewer) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().H).k().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.L.get(entity.getEntityId());
        if (entityTracker != null) {
            try {
                EntityTrackerEntry entry = (EntityTrackerEntry)ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
                if (entry != null) {
                    entry.a(((CraftPlayer)viewer).getHandle());
                    entry.b(((CraftPlayer)viewer).getHandle());
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
    }

    @Override
    public void sendRename(Player player, Entity entity, String name, boolean listMode) {
        try {
            if (entity.getType() == EntityType.PLAYER) {
                if (listMode) {
                    PacketHelperImpl.send(player, new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.f, ((CraftPlayer)player).getHandle()));
                } else {
                    PacketHelperImpl.forceRespawnPlayerEntity(entity, player);
                }
                return;
            }
            DataWatcher fakeData = new DataWatcher(((CraftEntity)entity).getHandle());
            ArrayList<DataWatcher.b> list = new ArrayList<DataWatcher.b>();
            list.add(new DataWatcher.b(ENTITY_DATA_ACCESSOR_CUSTOM_NAME.a(), ENTITY_DATA_ACCESSOR_CUSTOM_NAME.b(), Optional.of(Handler.componentToNMS(FormattedTextHelper.parse(name, ChatColor.WHITE)))));
            list.add(new DataWatcher.b(ENTITY_DATA_ACCESSOR_CUSTOM_NAME_VISIBLE.a(), ENTITY_DATA_ACCESSOR_CUSTOM_NAME_VISIBLE.b(), (Object)true));
            PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(entity.getEntityId(), list));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void generateNoCollideTeam(Player player, UUID noCollide) {
        this.removeNoCollideTeam(player, noCollide);
        ScoreboardTeam team = new ScoreboardTeam(SidebarImpl.dummyScoreboard, Utilities.generateRandomColors(8));
        team.g().add(noCollide.toString());
        team.a(ScoreboardTeamBase.EnumTeamPush.b);
        HashMap map = noCollideTeamMap.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        map.put(noCollide, team);
        PacketHelperImpl.send(player, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (boolean)true));
    }

    @Override
    public void removeNoCollideTeam(Player player, UUID noCollide) {
        if (noCollide == null || !player.isOnline()) {
            noCollideTeamMap.remove(player.getUniqueId());
            return;
        }
        HashMap<UUID, ScoreboardTeam> map = noCollideTeamMap.get(player.getUniqueId());
        if (map == null) {
            return;
        }
        ScoreboardTeam team = map.remove(noCollide);
        if (team != null) {
            PacketHelperImpl.send(player, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team));
        }
        if (map.isEmpty()) {
            noCollideTeamMap.remove(player.getUniqueId());
        }
    }

    @Override
    public void sendEntityMetadataFlagsUpdate(Player player, Entity entity) {
        ArrayList<DataWatcher.b> data = new ArrayList<DataWatcher.b>();
        byte flags = (Byte)((CraftEntity)entity).getHandle().aj().a(ENTITY_DATA_ACCESSOR_FLAGS);
        data.add(DataWatcher.b.a(ENTITY_DATA_ACCESSOR_FLAGS, (Object)flags));
        PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(entity.getEntityId(), data));
    }

    @Override
    public void sendEntityEffect(Player player, Entity entity, byte effectId) {
        PacketHelperImpl.send(player, new PacketPlayOutEntityStatus(((CraftEntity)entity).getHandle(), effectId));
    }

    @Override
    public int getPacketStats(Player player, boolean sent) {
        DenizenNetworkManagerImpl netMan = DenizenNetworkManagerImpl.getNetworkManager(player);
        return sent ? netMan.packetsSent : netMan.packetsReceived;
    }

    @Override
    public void setMapData(MapCanvas canvas, byte[] bytes, int x, int y, MapImage image) {
        if (x > 127 || y > 127) {
            return;
        }
        int width = Math.min(image.width, 128 - x);
        int height = Math.min(image.height, 128 - y);
        if (x + width <= 0 || y + height <= 0) {
            return;
        }
        try {
            int x2;
            boolean anyChanged = false;
            byte[] buffer = CANVAS_GET_BUFFER.invoke(canvas);
            int n = x2 = x < 0 ? -x : 0;
            while (x2 < width) {
                int y2;
                int n2 = y2 = y < 0 ? -y : 0;
                while (y2 < height) {
                    int index;
                    byte p = bytes[y2 * image.width + x2];
                    if (p != 0 && buffer[index = (y2 + y) * 128 + (x2 + x)] != p) {
                        buffer[index] = p;
                        anyChanged = true;
                    }
                    ++y2;
                }
                ++x2;
            }
            if (anyChanged) {
                WorldMap map = (WorldMap)MAPVIEW_WORLDMAP.get(canvas.getMapView());
                map.a(Math.max(x, 0), Math.max(y, 0));
                map.a(width + x - 1, height + y - 1);
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void setNetworkManagerFor(Player player) {
        DenizenNetworkManagerImpl.setNetworkManager(player);
    }

    @Override
    public void enableNetworkManager() {
        DenizenNetworkManagerImpl.enableNetworkManager();
    }

    @Override
    public void showDebugTestMarker(Player player, Location location, ColorTag color, String name, int time) {
        MinecraftKey packetKey = new MinecraftKey("minecraft", "debug/game_test_add_marker");
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        int colorInt = color.blue | color.green << 8 | color.red << 16 | color.alpha << 24;
        buf.writeInt(colorInt);
        buf.a(name.getBytes(StandardCharsets.UTF_8));
        buf.writeInt(time);
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(packetKey, buf);
        PacketHelperImpl.send(player, packet);
    }

    @Override
    public void clearDebugTestMarker(Player player) {
        MinecraftKey packetKey = new MinecraftKey("minecraft", "debug/game_test_clear");
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(packetKey, buf);
        PacketHelperImpl.send(player, packet);
    }

    @Override
    public void sendBrand(Player player, String brand) {
        MinecraftKey packetKey = new MinecraftKey("minecraft", "brand");
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(brand);
        PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(packetKey, buf);
        PacketHelperImpl.send(player, packet);
    }

    @Override
    public void sendCollectItemEntity(Player player, Entity taker, Entity item, int amount) {
        PacketPlayOutCollect packet = new PacketPlayOutCollect(item.getEntityId(), taker.getEntityId(), amount);
        PacketHelperImpl.send(player, packet);
    }

    @Override
    public void sendRelativeLookPacket(Player player, float yaw, float pitch) {
        PacketPlayOutPosition packet = new PacketPlayOutPosition(0.0, 0.0, 0.0, yaw, pitch, RelativeMovement.f, 0);
        DenizenNetworkManagerImpl.getNetworkManager((Player)player).oldManager.m.writeAndFlush((Object)packet);
    }

    public static void send(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().b.a(packet);
    }
}

