/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.ObjectProperty;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class InventoryContents
extends ObjectProperty<InventoryTag, ListTag> {
    public static boolean describes(InventoryTag inventory) {
        return true;
    }

    @Override
    public ListTag getPropertyValue() {
        if (!((InventoryTag)this.object).isGeneric() && !((InventoryTag)this.object).isSaving) {
            return null;
        }
        ListTag contents = this.getContents(false);
        if (contents == null || contents.isEmpty()) {
            return null;
        }
        return contents;
    }

    @Override
    public void setPropertyValue(ListTag list, Mechanism mechanism) {
        if (((InventoryTag)this.object).isGeneric() || !mechanism.isProperty) {
            ((InventoryTag)this.object).setContents(list, mechanism.context);
        }
    }

    @Override
    public String getPropertyId() {
        return "contents";
    }

    public InventoryContents(InventoryTag inventory) {
        this.object = inventory;
    }

    public ListTag getContents(boolean simple) {
        if (((InventoryTag)this.object).getInventory() == null) {
            return null;
        }
        int lastNonAir = -1;
        ListTag contents = new ListTag();
        for (ItemStack item : ((InventoryTag)this.object).getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) {
                lastNonAir = contents.size();
                if (simple) {
                    contents.add(new ItemTag(item).identifySimple());
                    continue;
                }
                contents.addObject(new ItemTag(item));
                continue;
            }
            contents.addObject(new ItemTag(Material.AIR));
        }
        ++lastNonAir;
        while (contents.size() > lastNonAir) {
            contents.remove(lastNonAir);
        }
        return contents;
    }

    public ListTag getContentsWithLore(String lore, boolean simple) {
        if (((InventoryTag)this.object).getInventory() == null) {
            return null;
        }
        ListTag contents = new ListTag();
        lore = ChatColor.stripColor((String)lore);
        block0: for (ItemStack item : ((InventoryTag)this.object).getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
            for (String line : item.getItemMeta().getLore()) {
                if (!ChatColor.stripColor((String)line).equalsIgnoreCase(lore)) continue;
                if (simple) {
                    contents.add(new ItemTag(item).identifySimple());
                    continue block0;
                }
                contents.addObject(new ItemTag(item));
                continue block0;
            }
        }
        return contents;
    }

    public static void register() {
        PropertyParser.registerTag(InventoryContents.class, MapTag.class, "map_slots", (attribute, prop) -> {
            MapTag map = new MapTag();
            ItemStack[] items = ((InventoryTag)prop.object).getContents();
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null || items[i].getType() == Material.AIR) continue;
                map.putObject(String.valueOf(i + 1), new ItemTag(items[i]));
            }
            return map;
        }, new String[0]);
        PropertyParser.registerTag(InventoryContents.class, ListTag.class, "list_contents", (attribute, prop) -> {
            if (attribute.startsWith("simple", 2)) {
                attribute.fulfill(1);
                return prop.getContents(true);
            }
            if (attribute.startsWith("with_lore", 2)) {
                attribute.fulfill(1);
                if (!attribute.hasParam()) {
                    return null;
                }
                String lore = attribute.getParam();
                attribute.fulfill(1);
                if (attribute.startsWith("simple", 2)) {
                    attribute.fulfill(1);
                    return prop.getContentsWithLore(lore, true);
                }
                return prop.getContentsWithLore(lore, false);
            }
            return prop.getContents(false);
        }, new String[0]);
        PropertyParser.registerMechanism(InventoryContents.class, ListTag.class, "contents", (prop, mechanism, param) -> prop.setPropertyValue((ListTag)param, mechanism), new String[0]);
    }
}

