/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;

public class EntityMaterial
implements Property {
    public static final String[] handledMechs = new String[]{"material"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        EntityTag entityTag = (EntityTag)object;
        Entity entity = entityTag.getBukkitEntity();
        return entity instanceof Enderman || entity instanceof Minecart || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && entity instanceof BlockDisplay;
    }

    public static EntityMaterial getFrom(ObjectTag _entity) {
        if (!EntityMaterial.describes(_entity)) {
            return null;
        }
        return new EntityMaterial((EntityTag)_entity);
    }

    public EntityMaterial(EntityTag _entity) {
        this.entity = _entity;
    }

    public static void register() {
        PropertyParser.registerTag(EntityMaterial.class, MaterialTag.class, "material", (attribute, object) -> object.getMaterial(), new String[0]);
    }

    public BlockData getBlockData() {
        EntityTag entityTag = this.entity;
        if (entityTag instanceof Enderman) {
            Enderman enderman = (Enderman)entityTag;
            return enderman.getCarriedBlock();
        }
        entityTag = this.entity;
        if (entityTag instanceof Minecart) {
            Minecart minecart = (Minecart)entityTag;
            return minecart.getDisplayBlockData();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (entityTag = this.entity) instanceof BlockDisplay) {
            BlockDisplay blockDisplay = (BlockDisplay)entityTag;
            return blockDisplay.getBlock();
        }
        return null;
    }

    public MaterialTag getMaterial() {
        BlockData data = this.getBlockData();
        if (data == null) {
            return new MaterialTag(Material.AIR);
        }
        return new MaterialTag(data);
    }

    @Override
    public String getPropertyString() {
        MaterialTag material = this.getMaterial();
        if (material.getMaterial() != Material.AIR) {
            return material.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "material";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("material") && mechanism.requireObject(MaterialTag.class)) {
            BlockData data = mechanism.valueAsType(MaterialTag.class).getModernData();
            Entity entity = this.entity.getBukkitEntity();
            if (entity instanceof Enderman) {
                Enderman enderman = (Enderman)entity;
                enderman.setCarriedBlock(data);
            } else if (entity instanceof Minecart) {
                Minecart minecart = (Minecart)entity;
                minecart.setDisplayBlockData(data);
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && entity instanceof BlockDisplay) {
                BlockDisplay blockDisplay = (BlockDisplay)entity;
                blockDisplay.setBlock(data);
            }
        }
    }
}

