/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemSpawnerDelay
implements Property {
    public static final String[] handledTags = new String[]{"spawner_spawn_delay", "spawner_minimum_spawn_delay", "spawner_maximum_spawn_delay"};
    public static final String[] handledMechs = new String[]{"spawner_delay_data"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)((ItemTag)item).getItemMeta()).getBlockState() instanceof CreatureSpawner;
    }

    public static ItemSpawnerDelay getFrom(ObjectTag _item) {
        if (!ItemSpawnerDelay.describes(_item)) {
            return null;
        }
        return new ItemSpawnerDelay((ItemTag)_item);
    }

    public ItemSpawnerDelay(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("spawner_spawn_delay")) {
            BlockStateMeta meta = (BlockStateMeta)this.item.getItemMeta();
            CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
            return new ElementTag(state.getDelay()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("spawner_minimum_spawn_delay")) {
            BlockStateMeta meta = (BlockStateMeta)this.item.getItemMeta();
            CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
            return new ElementTag(state.getMinSpawnDelay()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("spawner_maximum_spawn_delay")) {
            BlockStateMeta meta = (BlockStateMeta)this.item.getItemMeta();
            CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
            return new ElementTag(state.getMaxSpawnDelay()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        BlockStateMeta meta = (BlockStateMeta)this.item.getItemMeta();
        CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
        return state.getDelay() + "," + state.getMinSpawnDelay() + "," + state.getMaxSpawnDelay();
    }

    @Override
    public String getPropertyId() {
        return "spawner_delay_data";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("spawner_delay_data")) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            if (list.size() < 3) {
                return;
            }
            BlockStateMeta meta = (BlockStateMeta)this.item.getItemMeta();
            CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
            state.setDelay(Integer.parseInt(list.get(0)));
            int minDelay = Integer.parseInt(list.get(1));
            int maxDelay = Integer.parseInt(list.get(2));
            if (minDelay > state.getMaxSpawnDelay()) {
                state.setMaxSpawnDelay(maxDelay);
                state.setMinSpawnDelay(minDelay);
            } else {
                state.setMinSpawnDelay(minDelay);
                state.setMaxSpawnDelay(maxDelay);
            }
            meta.setBlockState((BlockState)state);
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

