/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ScriptUtilities {
    public static ScriptQueue createAndStartQueue(ScriptContainer container, String path, ScriptEntryData data) {
        return ScriptUtilities.createAndStartQueue(container, path, data, null, null, null, null, null, null);
    }

    public static ScriptQueue createAndStartQueue(ScriptContainer container, String path, ScriptEntryData data, ContextSource context, Consumer<ScriptQueue> configure, DurationTag speed, String id, ListTag definitions, Debuggable debugDefinitions) {
        List<ScriptEntry> entries;
        if (!container.canRunScripts) {
            Debug.echoError("The script container '" + container.getName() + "' is of type '" + container.getContainerType() + "' which cannot run scripts. Consider using a task script instead.");
            return null;
        }
        if (id == null) {
            id = container.getName();
        }
        if (data == null) {
            data = DenizenCore.implementation.getEmptyScriptEntryData();
        }
        if ((entries = path == null ? container.getBaseEntries(data.clone()) : container.getEntries(data.clone(), path)) == null) {
            return null;
        }
        if (speed == null) {
            if (container.contains("SPEED", String.class)) {
                speed = DurationTag.valueOf(container.getString("SPEED", "0"), DenizenCore.implementation.getTagContext(container));
            }
            if (speed == null) {
                speed = new DurationTag(CoreConfiguration.scriptQueueSpeed);
            }
        }
        ScriptQueue queue = speed.getTicks() > 0L ? new TimedQueue(id).setSpeed(speed.getTicks()) : new InstantQueue(id);
        queue.addEntries(entries);
        queue.contextSource = context;
        if (definitions != null) {
            List<String> definition_names = null;
            if (container.contains("definitions", String.class)) {
                String str = container.getString("definitions");
                definition_names = CoreUtilities.split(str, '|');
            }
            int x = 1;
            for (ObjectTag definition : definitions.objectForms) {
                String name = definition_names != null && definition_names.size() >= x ? definition_names.get(x - 1).trim() : String.valueOf(x);
                int squareBracket = name.indexOf(91);
                if (squareBracket != -1) {
                    name = name.substring(0, squareBracket).trim();
                }
                queue.addDefinition(name, definition);
                if (debugDefinitions != null && debugDefinitions.shouldDebug()) {
                    Debug.echoDebug(debugDefinitions, "Adding definition '" + name + "' as " + definition);
                }
                ++x;
            }
            queue.addDefinition("raw_context", definitions);
        }
        if (configure != null) {
            configure.accept(queue);
        }
        queue.start(true);
        return queue;
    }

    public static ScriptQueue createAndStartQueueArbitrary(String id, List<ScriptEntry> entries, ScriptEntryData data, ContextSource context, Consumer<ScriptQueue> configure) {
        if (data == null) {
            data = DenizenCore.implementation.getEmptyScriptEntryData();
        }
        ArrayList<ScriptEntry> cleanedEntries = new ArrayList<ScriptEntry>();
        InstantQueue queue = new InstantQueue(id);
        for (ScriptEntry entry : entries) {
            ScriptEntry newEntry = entry.clone();
            newEntry.queue = queue;
            newEntry.entryData = data.clone();
            newEntry.entryData.scriptEntry = newEntry;
            newEntry.updateContext();
            cleanedEntries.add(newEntry);
        }
        queue.addEntries(cleanedEntries);
        queue.contextSource = context;
        if (configure != null) {
            configure.accept(queue);
        }
        queue.start(true);
        return queue;
    }
}

