/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;

public class PlayerAnimatesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerAnimationEvent event;

    public PlayerAnimatesScriptEvent() {
        this.registerCouldMatcher("player animates (<'animation'>)");
        this.registerSwitches("with");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return path.eventArgLowerAt(2).isEmpty() || PlayerAnimatesScriptEvent.couldMatchEnum(path.eventArgLowerAt(2), PlayerAnimationType.values());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        String ani = path.eventArgLowerAt(2);
        if (ani.length() > 0 && !ani.equals("in") && !PlayerAnimatesScriptEvent.runGenericCheck(ani, this.event.getAnimationType().name())) {
            return false;
        }
        String with = path.switches.get("with");
        if (with != null && (this.event.getAnimationType() == PlayerAnimationType.ARM_SWING ? !new ItemTag(this.event.getPlayer().getEquipment().getItemInMainHand()).tryAdvancedMatcher(with) : this.event.getAnimationType() == PlayerAnimationType.OFF_ARM_SWING && !new ItemTag(this.event.getPlayer().getEquipment().getItemInOffHand()).tryAdvancedMatcher(with))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "animation": {
                return new ElementTag(this.event.getAnimationType().name());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerAnimates(PlayerAnimationEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.event = event;
        this.fire((Event)event);
    }
}

