/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.Inventory;

public class PlayerPreparesAnvilCraftScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PrepareAnvilEvent event;
    public ItemTag result;
    public PlayerTag player;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player prepares anvil craft")) {
            return false;
        }
        return PlayerPreparesAnvilCraftScriptEvent.couldMatchItem(path.eventArgLowerAt(4));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(4, this.result)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag element;
        if (determinationObj instanceof ElementTag && (element = (ElementTag)determinationObj).isInt()) {
            this.event.getInventory().setRepairCost(element.asInt());
            return true;
        }
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.result = ItemTag.valueOf(determination, path.container);
            this.event.setResult(this.result.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return this.result;
            }
            case "repair_cost": {
                return new ElementTag(this.event.getInventory().getRepairCost());
            }
            case "new_name": {
                return new ElementTag(this.event.getInventory().getRenameText());
            }
            case "inventory": {
                return InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(PrepareAnvilEvent event) {
        if (event.getInventory().getViewers().isEmpty()) {
            return;
        }
        HumanEntity humanEntity = (HumanEntity)event.getInventory().getViewers().get(0);
        if (EntityTag.isNPC((Entity)humanEntity)) {
            return;
        }
        this.event = event;
        this.result = new ItemTag(event.getResult());
        this.player = EntityTag.getPlayerFrom((Entity)humanEntity);
        this.fire((Event)event);
    }
}

