/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import org.bukkit.Registry;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class ItemTrim
extends ItemProperty<MapTag> {
    public static boolean describes(ItemTag item) {
        return item.getItemMeta() instanceof ArmorMeta;
    }

    @Override
    public MapTag getPropertyValue() {
        ArmorTrim currentTrim = ((ArmorMeta)this.getItemMeta()).getTrim();
        if (currentTrim == null) {
            return null;
        }
        MapTag map = new MapTag();
        map.putObject("material", new ElementTag(Utilities.namespacedKeyToString(currentTrim.getMaterial().getKey()), true));
        map.putObject("pattern", new ElementTag(Utilities.namespacedKeyToString(currentTrim.getPattern().getKey()), true));
        return map;
    }

    @Override
    public boolean isDefaultValue(MapTag map) {
        return map.map.isEmpty();
    }

    @Override
    public String getPropertyId() {
        return "trim";
    }

    @Override
    public void setPropertyValue(MapTag map, Mechanism mechanism) {
        ElementTag mat = map.getElement("material");
        ElementTag pat = map.getElement("pattern");
        ArmorMeta meta = (ArmorMeta)this.getItemMeta();
        ArmorTrim currentTrim = meta.getTrim();
        if (mat == null && currentTrim == null) {
            mechanism.echoError("The armor piece must have a material already if you want to omit it!");
            return;
        }
        if (pat == null && currentTrim == null) {
            mechanism.echoError("The armor piece must have a pattern already if you want to omit it!");
            return;
        }
        TrimMaterial material = mat == null ? currentTrim.getMaterial() : (TrimMaterial)Registry.TRIM_MATERIAL.get(Utilities.parseNamespacedKey(mat.asString()));
        TrimPattern pattern = pat == null ? currentTrim.getPattern() : (TrimPattern)Registry.TRIM_PATTERN.get(Utilities.parseNamespacedKey(pat.asString()));
        meta.setTrim(new ArmorTrim(material, pattern));
        this.setItemMeta((ItemMeta)meta);
    }

    public static void register() {
        ItemTrim.autoRegister("trim", ItemTrim.class, MapTag.class, false, new String[0]);
    }
}

