/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ColorTag
implements ObjectTag {
    public static HashMap<ColorTag, String> nameByColor = new HashMap();
    public static HashMap<String, ColorTag> colorsByName = new HashMap();
    public static ArrayList<String> colorNames = new ArrayList();
    public static AsciiMatcher HEX_MATCHER = new AsciiMatcher("0123456789abcdefABCDEF");
    public static final char COLOR_CHAR = '\u00a7';
    public int red;
    public int green;
    public int blue;
    public int alpha;
    String prefix = "color";
    public static ObjectTagProcessor<ColorTag> tagProcessor;

    public static void registerNamedColor(String name, int rgb, int a) {
        ColorTag color = ColorTag.fromRGB(rgb);
        color.alpha = a;
        nameByColor.put(color, CoreUtilities.toLowerCase(name));
        colorsByName.put(CoreUtilities.toLowerCase(name), color);
        colorNames.add(CoreUtilities.toLowerCase(name));
    }

    public static void registerMinecraftCode(String name, int rgb) {
        colorsByName.put(name, ColorTag.fromRGB(rgb));
    }

    @Fetchable(value="co")
    public static ColorTag valueOf(String string, TagContext context) {
        String pieces;
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("co@")) {
            string = string.substring("co@".length());
        }
        if (string.equals("random")) {
            if (TagManager.isStaticParsing) {
                return null;
            }
            return new ColorTag(CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256));
        }
        if (string.startsWith("#") && string.length() == 7 && HEX_MATCHER.isOnlyMatches(string.substring(1))) {
            return new ColorTag(ColorTag.fromRGB(Integer.parseInt(string.substring(1), 16)));
        }
        if (string.startsWith("#") && string.length() == 9 && HEX_MATCHER.isOnlyMatches(string.substring(1))) {
            ColorTag result = new ColorTag(ColorTag.fromRGB(Integer.parseInt(string.substring(1, 7), 16)));
            result.alpha = Integer.parseInt(string.substring(7, 9), 16);
            return result;
        }
        if (string.startsWith("\u00a7#") && string.length() == 8 && HEX_MATCHER.isOnlyMatches(string.substring(2))) {
            return new ColorTag(ColorTag.fromRGB(Integer.parseInt(string.substring(2), 16)));
        }
        if (string.startsWith("\u00a7x") && string.length() == 14 && (pieces = string.substring(2).replace(String.valueOf('\u00a7'), "")).length() == 6 && HEX_MATCHER.isOnlyMatches(pieces)) {
            return new ColorTag(ColorTag.fromRGB(Integer.parseInt(pieces, 16)));
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() == 3 || split.size() == 4) {
            int alpha;
            if (!(ArgumentHelper.matchesInteger(split.get(0)) && ArgumentHelper.matchesInteger(split.get(1)) && ArgumentHelper.matchesInteger(split.get(2)))) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Cannot construct ColorTag - Red, Green, or Blue input not a number.");
                }
                return null;
            }
            if (split.size() == 4 && !ArgumentHelper.matchesInteger(split.get(3))) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Cannot construct ColorTag - alpha not a number.");
                }
                return null;
            }
            int red = Integer.parseInt(split.get(0));
            int green = Integer.parseInt(split.get(1));
            int blue = Integer.parseInt(split.get(2));
            int n = alpha = split.size() == 4 ? Integer.parseInt(split.get(3)) : 255;
            if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255 || alpha < 0 || alpha > 255) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Cannot construct ColorTag - values out of range, must be between 0 and 255.");
                }
                return null;
            }
            return new ColorTag(red, green, blue, alpha);
        }
        ColorTag col = colorsByName.get(string);
        if (col != null) {
            return new ColorTag(col);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("co@")) {
            return true;
        }
        return ColorTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public ColorTag(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public ColorTag(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public ColorTag(ColorTag color) {
        this(color.red, color.green, color.blue, color.alpha);
    }

    public Color getAWTColor() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String identify() {
        String name = nameByColor.get(this);
        if (name != null) {
            return "co@" + name;
        }
        if (this.alpha != 255) {
            return "co@" + this.red + "," + this.green + "," + this.blue + "," + this.alpha;
        }
        return "co@" + this.red + "," + this.green + "," + this.blue;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public int hashCode() {
        return this.red + this.green << 8 + this.blue << 16 + this.alpha << 24;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ColorTag)) {
            return false;
        }
        ColorTag otherColor = (ColorTag)other;
        return this.red == otherColor.red && this.blue == otherColor.blue && this.green == otherColor.green && this.alpha == otherColor.alpha;
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "hex", (attribute, object) -> {
            if (object.alpha != 255) {
                return new ElementTag("#" + CoreUtilities.hexEncode(new byte[]{(byte)object.red, (byte)object.green, (byte)object.blue, (byte)object.alpha}));
            }
            return new ElementTag("#" + CoreUtilities.hexEncode(new byte[]{(byte)object.red, (byte)object.green, (byte)object.blue}));
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "rgb_integer", (attribute, object) -> new ElementTag(object.red << 16 | object.green << 8 | object.blue), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "argb_integer", (attribute, object) -> new ElementTag((long)object.alpha << 24 | (long)object.red << 16 | (long)object.green << 8 | (long)object.blue), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "red", (attribute, object) -> new ElementTag(object.red), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "green", (attribute, object) -> new ElementTag(object.green), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "blue", (attribute, object) -> new ElementTag(object.blue), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "alpha", (attribute, object) -> new ElementTag(object.alpha), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "rgb", (attribute, object) -> new ElementTag(object.red + "," + object.green + "," + object.blue), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "rgba", (attribute, object) -> new ElementTag(object.red + "," + object.green + "," + object.blue + "," + object.alpha), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "hue", (attribute, object) -> new ElementTag(object.toHSB()[0]), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "saturation", (attribute, object) -> new ElementTag(object.toHSB()[1]), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "brightness", (attribute, object) -> new ElementTag(object.toHSB()[2]), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "hsv", (attribute, object) -> {
            int[] HSV = object.toHSB();
            return new ElementTag(HSV[0] + "," + HSV[1] + "," + HSV[2]);
        }, new String[0]);
        tagProcessor.registerStaticTag(ColorTag.class, "with_red", (attribute, object) -> new ColorTag(attribute.getIntParam(), object.green, object.blue, object.alpha), new String[0]);
        tagProcessor.registerStaticTag(ColorTag.class, "with_green", (attribute, object) -> new ColorTag(object.red, attribute.getIntParam(), object.blue, object.alpha), new String[0]);
        tagProcessor.registerStaticTag(ColorTag.class, "with_blue", (attribute, object) -> new ColorTag(object.red, object.green, attribute.getIntParam(), object.alpha), new String[0]);
        tagProcessor.registerStaticTag(ColorTag.class, "with_alpha", (attribute, object) -> new ColorTag(object.red, object.green, object.blue, attribute.getIntParam()), new String[0]);
        tagProcessor.registerStaticTag(ColorTag.class, "with_hue", (attribute, object) -> {
            int[] HSB = object.toHSB();
            HSB[0] = attribute.getIntParam();
            return ColorTag.fromHSB(HSB);
        }, new String[0]);
        tagProcessor.registerStaticTag(ColorTag.class, "with_saturation", (attribute, object) -> {
            int[] HSB = object.toHSB();
            HSB[1] = attribute.getIntParam();
            return ColorTag.fromHSB(HSB);
        }, new String[0]);
        tagProcessor.registerStaticTag(ColorTag.class, "with_brightness", (attribute, object) -> {
            int[] HSB = object.toHSB();
            HSB[2] = attribute.getIntParam();
            return ColorTag.fromHSB(HSB);
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.identify().substring("co@".length())), new String[0]);
        tagProcessor.registerTag(ColorTag.class, ColorTag.class, "mix", (attribute, object, mixWith) -> new ColorTag(object.mixWith((ColorTag)mixWith)), new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public ColorTag mixWith(ColorTag two) {
        int totalRed = this.red + two.red;
        int totalGreen = this.green + two.green;
        int totalBlue = this.blue + two.blue;
        int totalAlpha = this.alpha + two.alpha;
        int totalMax = Math.max(Math.max(this.red, this.green), this.blue) + Math.max(Math.max(two.red, two.green), two.blue);
        float averageRed = totalRed / 2;
        float averageGreen = totalGreen / 2;
        float averageBlue = totalBlue / 2;
        float averageAlpha = totalAlpha / 2;
        float averageMax = totalMax / 2;
        float maximumOfAverages = Math.max(Math.max(averageRed, averageGreen), averageBlue);
        float gainFactor = averageMax / maximumOfAverages;
        return new ColorTag((int)(averageRed * gainFactor), (int)(averageGreen * gainFactor), (int)(averageBlue * gainFactor), (int)averageAlpha);
    }

    public int asRGB() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public static ColorTag fromRGB(int rgb) {
        return new ColorTag(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static ColorTag fromHSB(int[] hsv) {
        int rgb = Color.HSBtoRGB((float)hsv[0] / 255.0f, (float)hsv[1] / 255.0f, (float)hsv[2] / 255.0f) & 0xFFFFFF;
        return new ColorTag(ColorTag.fromRGB(rgb));
    }

    public int[] toHSB() {
        float[] base = Color.RGBtoHSB(this.red, this.green, this.blue, null);
        return new int[]{Math.round(base[0] * 255.0f), Math.round(base[1] * 255.0f), Math.round(base[2] * 255.0f)};
    }

    public static float fromSRGB(float x) {
        if ((double)(x /= 255.0f) <= 0.04045) {
            return x / 12.92f;
        }
        return (float)Math.pow(((double)x + 0.055) / 1.055, 2.4);
    }

    public static float toSRGB(float x) {
        return 255.9999f * (x <= 0.0031308f ? 12.92f * x : 1.055f * (float)Math.pow(x, 0.4166666567325592) - 0.055f);
    }

    static {
        ColorTag.registerNamedColor("WHITE", 0xFFFFFF, 255);
        ColorTag.registerNamedColor("SILVER", 0xC0C0C0, 255);
        ColorTag.registerNamedColor("GRAY", 0x808080, 255);
        ColorTag.registerNamedColor("BLACK", 0, 255);
        ColorTag.registerNamedColor("RED", 0xFF0000, 255);
        ColorTag.registerNamedColor("MAROON", 0x800000, 255);
        ColorTag.registerNamedColor("YELLOW", 0xFFFF00, 255);
        ColorTag.registerNamedColor("OLIVE", 0x808000, 255);
        ColorTag.registerNamedColor("LIME", 65280, 255);
        ColorTag.registerNamedColor("GREEN", 32768, 255);
        ColorTag.registerNamedColor("AQUA", 65535, 255);
        ColorTag.registerNamedColor("TEAL", 32896, 255);
        ColorTag.registerNamedColor("BLUE", 255, 255);
        ColorTag.registerNamedColor("NAVY", 128, 255);
        ColorTag.registerNamedColor("FUCHSIA", 0xFF00FF, 255);
        ColorTag.registerNamedColor("PURPLE", 0x800080, 255);
        ColorTag.registerNamedColor("ORANGE", 16753920, 255);
        ColorTag.registerNamedColor("TRANSPARENT", 0, 0);
        ColorTag.registerMinecraftCode("\u00a70", 0);
        ColorTag.registerMinecraftCode("\u00a71", 170);
        ColorTag.registerMinecraftCode("\u00a72", 43520);
        ColorTag.registerMinecraftCode("\u00a73", 43690);
        ColorTag.registerMinecraftCode("\u00a74", 0xAA0000);
        ColorTag.registerMinecraftCode("\u00a75", 0xAA00AA);
        ColorTag.registerMinecraftCode("\u00a76", 0xFFAA00);
        ColorTag.registerMinecraftCode("\u00a77", 0xAAAAAA);
        ColorTag.registerMinecraftCode("\u00a78", 0x555555);
        ColorTag.registerMinecraftCode("\u00a79", 0x5555FF);
        ColorTag.registerMinecraftCode("\u00a7a", 0x55FF55);
        ColorTag.registerMinecraftCode("\u00a7b", 0x55FFFF);
        ColorTag.registerMinecraftCode("\u00a7c", 0xFF5555);
        ColorTag.registerMinecraftCode("\u00a7d", 0xFF55FF);
        ColorTag.registerMinecraftCode("\u00a7e", 0xFFFF55);
        ColorTag.registerMinecraftCode("\u00a7f", 0xFFFFFF);
        tagProcessor = new ObjectTagProcessor();
    }
}

