/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.server.ListPingScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.paper.PaperModule;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerListPingScriptEventPaperImpl
extends ListPingScriptEvent {
    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("protocol_version:") && ArgumentHelper.matchesInteger(determination.substring("protocol_version:".length()))) {
            ((PaperServerListPingEvent)this.event).setProtocolVersion(Integer.parseInt(determination.substring("protocol_version:".length())));
            return true;
        }
        if (lower.startsWith("version_name:")) {
            ((PaperServerListPingEvent)this.event).setVersion(determination.substring("version_name:".length()));
            return true;
        }
        if (lower.startsWith("exclude_players:")) {
            HashSet<UUID> exclusions = new HashSet<UUID>();
            for (PlayerTag player : ListTag.valueOf(determination.substring("exclude_players:".length()), this.getTagContext(path)).filter(PlayerTag.class, this.getTagContext(path))) {
                exclusions.add(player.getUUID());
            }
            Iterator players = ((PaperServerListPingEvent)this.event).iterator();
            while (players.hasNext()) {
                if (!exclusions.contains(((Player)players.next()).getUniqueId())) continue;
                players.remove();
            }
            return true;
        }
        if (lower.startsWith("alternate_player_text:")) {
            if (!CoreConfiguration.allowRestrictedActions) {
                Debug.echoError("Cannot use 'alternate_player_text' in list ping event: 'Allow restricted actions' is disabled in Denizen config.yml.");
                return true;
            }
            ((PaperServerListPingEvent)this.event).getPlayerSample().clear();
            for (String line : ListTag.valueOf(determination.substring("alternate_player_text:".length()), this.getTagContext(path))) {
                FakeProfile lineProf = new FakeProfile();
                lineProf.setName(line);
                ((PaperServerListPingEvent)this.event).getPlayerSample().add(lineProf);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public void setMotd(String text) {
        this.event.motd(PaperModule.parseFormattedText(text, ChatColor.WHITE));
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "motd": {
                return new ElementTag(PaperModule.stringifyComponent(this.event.motd()));
            }
            case "protocol_version": {
                return new ElementTag(((PaperServerListPingEvent)this.event).getProtocolVersion());
            }
            case "version_name": {
                return new ElementTag(((PaperServerListPingEvent)this.event).getVersion());
            }
            case "client_protocol_version": {
                return new ElementTag(((PaperServerListPingEvent)this.event).getClient().getProtocolVersion());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onListPing(PaperServerListPingEvent event) {
        this.syncFire((ServerListPingEvent)event);
    }

    public static class FakeProfile
    implements PlayerProfile {
        public String name;

        @Nullable
        public String getName() {
            return this.name;
        }

        @NotNull
        public String setName(@Nullable String s) {
            String old = this.name;
            this.name = s;
            return old;
        }

        @Nullable
        public UUID getUniqueId() {
            return null;
        }

        @Nullable
        public UUID getId() {
            return null;
        }

        @Nullable
        public UUID setId(@Nullable UUID uuid) {
            return null;
        }

        @NotNull
        public PlayerTextures getTextures() {
            return null;
        }

        public void setTextures(@Nullable PlayerTextures playerTextures) {
        }

        @NotNull
        public Set<ProfileProperty> getProperties() {
            return null;
        }

        public boolean hasProperty(@Nullable String s) {
            return false;
        }

        public void setProperty(@NotNull ProfileProperty profileProperty) {
        }

        public void setProperties(@NotNull Collection<ProfileProperty> collection) {
        }

        public boolean removeProperty(@Nullable String s) {
            return false;
        }

        public void clearProperties() {
        }

        public boolean isComplete() {
            return false;
        }

        @NotNull
        public CompletableFuture<PlayerProfile> update() {
            return null;
        }

        public @NotNull org.bukkit.profile.PlayerProfile clone() {
            return null;
        }

        public boolean completeFromCache() {
            return false;
        }

        public boolean completeFromCache(boolean b2) {
            return false;
        }

        public boolean completeFromCache(boolean b2, boolean b1) {
            return false;
        }

        public boolean complete(boolean b2) {
            return false;
        }

        public boolean complete(boolean b2, boolean b1) {
            return false;
        }

        @NotNull
        public Map<String, Object> serialize() {
            return null;
        }
    }
}

