/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class ExperienceCommand
extends AbstractCommand {
    public ExperienceCommand() {
        this.setName("experience");
        this.setSyntax("experience [set/give/take] (level) [<#>]");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static int XP_FOR_NEXT_LEVEL(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static long TOTAL_XP_FOR_LEVEL(int level) {
        long count = 0L;
        for (int i = 0; i < level; ++i) {
            count += (long)ExperienceCommand.XP_FOR_NEXT_LEVEL(i);
        }
        return count;
    }

    public static void setTotalExperience(PlayerTag player, int exp) {
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        ExperienceCommand.giveExperiencePoints(player, exp);
    }

    public static void giveExperiencePoints(PlayerTag player, int amount) {
        float xp;
        if (player.isOnline()) {
            player.getPlayerEntity().giveExp(amount);
            return;
        }
        int level = player.getLevel();
        for (xp = player.getExp() + (float)amount / (float)ExperienceCommand.XP_FOR_NEXT_LEVEL(level); xp >= 1.0f; xp /= (float)ExperienceCommand.XP_FOR_NEXT_LEVEL(++level)) {
            xp = (xp - 1.0f) * (float)ExperienceCommand.XP_FOR_NEXT_LEVEL(level);
        }
        player.setTotalExperience(Math.min(player.getTotalExperience() + amount, Integer.MAX_VALUE));
        player.setExp(xp);
        player.setLevel(level);
    }

    public static void takeExperience(PlayerTag player, int toTake) {
        int pastLevelStart = (int)(player.getExp() * (float)ExperienceCommand.XP_FOR_NEXT_LEVEL(player.getLevel()));
        while (toTake >= pastLevelStart) {
            toTake -= pastLevelStart;
            player.setExp(0.0f);
            if (player.getLevel() == 0) {
                return;
            }
            player.setLevel(player.getLevel() - 1);
            pastLevelStart = ExperienceCommand.XP_FOR_NEXT_LEVEL(player.getLevel());
        }
        int newAmount = pastLevelStart - toTake;
        player.setExp((float)newAmount / (float)ExperienceCommand.XP_FOR_NEXT_LEVEL(player.getLevel()));
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="type") Type type, @ArgName(value="level") boolean level, @ArgLinear @ArgName(value="quantity") int quantity) {
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        if (player == null) {
            throw new InvalidArgumentsRuntimeException("The Experience command requires a linked player.");
        }
        if (quantity < 0) {
            switch (type) {
                case SET: {
                    Debug.echoError("Cannot set negative experience.");
                    return;
                }
                case GIVE: {
                    quantity = -quantity;
                    type = Type.TAKE;
                    break;
                }
                case TAKE: {
                    quantity = -quantity;
                    type = Type.GIVE;
                }
            }
        }
        switch (type) {
            case SET: {
                if (level) {
                    player.setLevel(quantity);
                    break;
                }
                ExperienceCommand.setTotalExperience(player, quantity);
                break;
            }
            case GIVE: {
                if (level) {
                    player.setLevel(player.getLevel() + quantity);
                    break;
                }
                ExperienceCommand.giveExperiencePoints(player, quantity);
                break;
            }
            case TAKE: {
                if (level) {
                    int value = player.getLevel() - quantity;
                    player.setLevel(value <= 0 ? 0 : value);
                    break;
                }
                ExperienceCommand.takeExperience(player, quantity);
            }
        }
    }

    public static enum Type {
        SET,
        GIVE,
        TAKE;

    }
}

