/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(BiomeBase.ClimateSettings.class, Boolean.TYPE, Float.TYPE, BiomeBase.TemperatureModifier.class, Float.TYPE);
    public Holder<BiomeBase> biomeHolder;
    public WorldServer world;

    public BiomeNMSImpl(WorldServer world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeHolder = world.B_().d(Registries.ap).b(ResourceKey.a((ResourceKey)Registries.ap, (MinecraftKey)new MinecraftKey(name))).orElse(null);
    }

    @Override
    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        BiomeBase.Precipitation precipitation = ((BiomeBase)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location));
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case BiomeBase.Precipitation.b -> BiomeNMS.DownfallType.RAIN;
            case BiomeBase.Precipitation.c -> BiomeNMS.DownfallType.SNOW;
            case BiomeBase.Precipitation.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    @Override
    public float getHumidity() {
        return ((BiomeBase)this.biomeHolder.a()).i.d();
    }

    @Override
    public float getBaseTemperature() {
        return ((BiomeBase)this.biomeHolder.a()).g();
    }

    @Override
    public float getTemperatureAt(Location location) {
        return ((BiomeBase)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location));
    }

    @Override
    public boolean hasDownfall() {
        return ((BiomeBase)this.biomeHolder.a()).c();
    }

    @Override
    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.c);
    }

    @Override
    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.b);
    }

    @Override
    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.a);
    }

    @Override
    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.f);
    }

    @Override
    public int getFoliageColor() {
        if (((BiomeBase)this.biomeHolder.a()).f() != 0) {
            return ((BiomeBase)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, BiomeBase.TemperatureModifier temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(BiomeBase.class, ReflectionMappingsInfo.Biome_climateSettings, this.biomeHolder.a(), newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    @Override
    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    @Override
    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    @Override
    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(BiomeFog.class, ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, ((BiomeBase)this.biomeHolder.a()).h(), Optional.of(color));
    }

    @Override
    public int getFogColor() {
        return ((BiomeBase)this.biomeHolder.a()).e();
    }

    @Override
    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(BiomeFog.class, ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, ((BiomeBase)this.biomeHolder.a()).h(), color);
    }

    @Override
    public int getWaterFogColor() {
        return ((BiomeBase)this.biomeHolder.a()).j();
    }

    @Override
    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(BiomeFog.class, ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, ((BiomeBase)this.biomeHolder.a()).h(), color);
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        BiomeSettingsMobs mobs = ((BiomeBase)this.biomeHolder.a()).b();
        WeightedRandomList typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (BiomeSettingsMobs.c meta : typeSettingList.e()) {
            try {
                String n = EntityTypes.a((EntityTypes)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    @Override
    public void setTo(Block block) {
        Chunk chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        BlockPosition pos = new BlockPosition(block.getX(), 0, block.getZ());
        if (this.world.A(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public BiomeBase.TemperatureModifier getTemperatureModifier() {
        return ((BiomeBase)this.biomeHolder.a()).i.c();
    }
}

