/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;

public class LingeringPotionSplashScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LingeringPotionSplashEvent event;
    public LocationTag location;
    public ItemTag item;

    public LingeringPotionSplashScriptEvent() {
        this.registerCouldMatcher("lingering <item> splash|splashes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(1, this.item)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "radius" -> new ElementTag(this.event.getAreaEffectCloud().getRadius());
            case "duration" -> new DurationTag((long)this.event.getAreaEffectCloud().getDuration());
            case "potion" -> this.item;
            case "entity" -> new EntityTag((Entity)this.event.getEntity());
            case "cloud" -> new EntityTag((Entity)this.event.getAreaEffectCloud());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        this.item = new ItemTag(event.getEntity().getItem());
        this.location = new LocationTag(event.getAreaEffectCloud().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

