/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ExSustainedCommandHandler
implements CommandExecutor,
TabCompleter,
Listener {
    public HashMap<UUID, TimedQueue> playerQueues = new HashMap();

    public void enableFor(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.playerQueues.remove(event.getPlayer().getUniqueId());
    }

    public TimedQueue getOrMakeQueue(Player player, boolean quiet) {
        UUID id = player == null ? new UUID(0L, 0L) : player.getUniqueId();
        TimedQueue queue = this.playerQueues.get(id);
        if (queue != null && !queue.isStopped) {
            return queue;
        }
        queue = new TimedQueue("EX_SUSTAINED_COMMAND", 0L);
        queue.waitWhenEmpty = true;
        this.playerQueues.put(id, queue);
        return queue;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String alias, String[] args) {
        PlayerTag playerTag;
        Player player;
        boolean quiet;
        ArrayList<Object> entries = new ArrayList<Object>();
        String entry = String.join((CharSequence)" ", args);
        boolean bl = quiet = !Settings.showExDebug();
        if (entry.length() > 3 && entry.startsWith("-q ")) {
            quiet = !quiet;
            entry = entry.substring("-q ".length());
        }
        if (entry.length() < 2) {
            sender.sendMessage("/exs (-q) <denizen script command> (arguments)");
            return true;
        }
        TimedQueue queue = this.getOrMakeQueue(sender instanceof Player ? (player = (Player)sender) : null, quiet);
        queue.debugOutput = !quiet && sender instanceof Player ? s -> sender.spigot().sendMessage(FormattedTextHelper.parse(s.replace("<FORCE_ALIGN>", ""), net.md_5.bungee.api.ChatColor.WHITE)) : null;
        if (queue.isPaused() || queue.isDelayed()) {
            sender.sendMessage(ChatColor.YELLOW + "Sustained queue is currently paused or waiting, adding command to queue for later execution.");
        } else if (Settings.showExHelp()) {
            if (CoreConfiguration.shouldShowDebug) {
                if (quiet) {
                    sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... check the console for full debug output!");
                } else {
                    sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command...");
                }
            } else {
                sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... to see debug, use /denizen debug");
            }
        }
        entries.add(entry);
        NPCTag npc = null;
        if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
            npc = new NPCTag(Depends.citizens.getNPCSelector().getSelected(sender));
        }
        if (sender instanceof Player) {
            Player player2 = (Player)sender;
            playerTag = new PlayerTag(player2);
        } else {
            playerTag = null;
        }
        List<ScriptEntry> scriptEntries = ScriptBuilder.buildScriptEntries(entries, null, new BukkitScriptEntryData(playerTag, npc));
        queue.addEntries(scriptEntries);
        if (!queue.is_started) {
            queue.start();
        } else {
            queue.onStart();
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] rawArgs) {
        return Denizen.getInstance().exCommand.onTabComplete(sender, cmd, alias, rawArgs);
    }
}

