/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import net.citizensnpcs.api.npc.NPC;

public class EntitySneaking
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return true;
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.getEntity().isSneaking());
    }

    @Override
    public boolean isDefaultValue(ElementTag value) {
        return !value.asBoolean();
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        if (mechanism.requireBoolean()) {
            boolean sneaking = value.asBoolean();
            this.getEntity().setSneaking(sneaking);
            if (((EntityTag)this.object).isCitizensNPC()) {
                NPC npc = ((EntityTag)this.object).getDenizenNPC().getCitizen();
                if (sneaking) {
                    ((SneakingTrait)npc.getOrAddTrait(SneakingTrait.class)).sneak();
                } else if (npc.hasTrait(SneakingTrait.class)) {
                    ((SneakingTrait)npc.getTraitNullable(SneakingTrait.class)).stand();
                    npc.removeTrait(SneakingTrait.class);
                }
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "is_sneaking";
    }

    public static void register() {
        EntitySneaking.autoRegister("is_sneaking", EntitySneaking.class, ElementTag.class, false, new String[0]);
    }
}

