/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.item.ItemPotion;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityPotionEffectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public EntityPotionEffectEvent event;

    public EntityPotionEffectScriptEvent() {
        this.registerCouldMatcher("<entity> potion effects modified");
        this.registerCouldMatcher("<entity> potion effects <'change_action'>");
        this.registerSwitches("cause", "effect");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        String change = path.eventArgAt(3);
        return change.equals("modified") || EntityPotionEffectScriptEvent.couldMatchEnum(change, EntityPotionEffectEvent.Action.values());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        String change = path.eventArgAt(3);
        if (!change.equals("modified") && !EntityPotionEffectScriptEvent.runGenericCheck(change, CoreUtilities.toLowerCase(this.event.getAction().name()))) {
            return false;
        }
        if (!this.entity.tryAdvancedMatcher(target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!EntityPotionEffectScriptEvent.runGenericSwitchCheck(path, "cause", CoreUtilities.toLowerCase(this.event.getCause().name()))) {
            return false;
        }
        if (!EntityPotionEffectScriptEvent.runGenericSwitchCheck(path, "effect", CoreUtilities.toLowerCase(this.event.getModifiedType().getName()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("override:")) {
            this.event.setOverride(lower.substring("override".length()).equals("true"));
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity.getDenizenObject();
            case "cause" -> new ElementTag((Enum<?>)this.event.getCause());
            case "action" -> new ElementTag((Enum<?>)this.event.getAction());
            case "effect_type" -> new ElementTag(this.event.getModifiedType().getName());
            case "override" -> new ElementTag(this.event.isOverride());
            case "new_effect" -> {
                if (this.event.getNewEffect() == null) {
                    yield null;
                }
                yield new ElementTag(ItemPotion.stringifyEffect(this.event.getNewEffect(), null));
            }
            case "old_effect" -> {
                if (this.event.getOldEffect() == null) {
                    yield null;
                }
                yield new ElementTag(ItemPotion.stringifyEffect(this.event.getOldEffect(), null));
            }
            case "new_effect_data" -> {
                if (this.event.getNewEffect() == null) {
                    yield null;
                }
                yield ItemPotion.effectToMap(this.event.getNewEffect());
            }
            case "old_effect_data" -> {
                if (this.event.getOldEffect() == null) {
                    yield null;
                }
                yield ItemPotion.effectToMap(this.event.getOldEffect());
            }
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onEntityPotionEffect(EntityPotionEffectEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

