/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.properties.item.ItemPotion;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerBeaconEffectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public BeaconEffectEvent event;

    public PlayerBeaconEffectScriptEvent() {
        this.registerCouldMatcher("player beacon effect applied");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        try {
            this.event.setEffect(ItemPotion.parseEffect(determinationObj.toString(), (TagContext)this.getTagContext(path)));
            return true;
        }
        catch (Exception e2) {
            Debug.echoError(e2);
            return super.applyDetermination(path, determinationObj);
        }
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> new LocationTag(this.event.getBlock().getLocation());
            case "effect" -> new ElementTag(ItemPotion.stringifyEffect(this.event.getEffect(), null));
            case "effect_data" -> ItemPotion.effectToMap(this.event.getEffect());
            case "effect_type" -> new ElementTag(this.event.getEffect().getType().getName());
            case "is_primary" -> new ElementTag(this.event.isPrimary());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void beaconEffectEvent(BeaconEffectEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.event = event;
        this.fire((Event)event);
    }
}

