/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Goat;
import org.bukkit.inventory.EquipmentSlot;

public class PaperEntityExtensions {
    public static void register() {
        EntityTag.tagProcessor.registerTag(ElementTag.class, "spawn_reason", (attribute, entity) -> new ElementTag((Enum<?>)entity.getBukkitEntity().getEntitySpawnReason()), new String[0]);
        EntityTag.tagProcessor.registerTag(ElementTag.class, "xp_spawn_reason", (attribute, entity) -> {
            Entity patt1913$temp = entity.getBukkitEntity();
            if (!(patt1913$temp instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + entity + " is not an experience orb.");
                return null;
            }
            ExperienceOrb experienceOrb = (ExperienceOrb)patt1913$temp;
            return new ElementTag((Enum<?>)experienceOrb.getSpawnReason());
        }, new String[0]);
        EntityTag.tagProcessor.registerTag(EntityFormObject.class, "xp_trigger", (attribute, entity) -> {
            Entity patt2707$temp = entity.getBukkitEntity();
            if (!(patt2707$temp instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + entity + " is not an experience orb.");
                return null;
            }
            ExperienceOrb experienceOrb = (ExperienceOrb)patt2707$temp;
            UUID uuid = experienceOrb.getTriggerEntityId();
            if (uuid == null) {
                return null;
            }
            Entity e2 = EntityTag.getEntityForID(uuid);
            if (e2 == null) {
                return null;
            }
            return new EntityTag(e2).getDenizenObject();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "xp_source", (attribute, entity) -> {
            Entity patt3763$temp = entity.getBukkitEntity();
            if (!(patt3763$temp instanceof ExperienceOrb)) {
                attribute.echoError("Entity " + entity + " is not an experience orb.");
                return null;
            }
            ExperienceOrb experienceOrb = (ExperienceOrb)patt3763$temp;
            UUID uuid = experienceOrb.getSourceEntityId();
            if (uuid == null) {
                return null;
            }
            Entity e2 = EntityTag.getEntityForID(uuid);
            if (e2 == null) {
                return null;
            }
            return new EntityTag(e2).getDenizenObject();
        }, new String[0]);
        EntityTag.tagProcessor.registerTag(LocationTag.class, "spawn_location", (attribute, entity) -> {
            Location loc = entity.getBukkitEntity().getOrigin();
            return loc != null ? new LocationTag(loc) : null;
        }, new String[0]);
        EntityTag.tagProcessor.registerTag(ElementTag.class, "from_spawner", (attribute, entity) -> new ElementTag(entity.getBukkitEntity().fromMobSpawner()), new String[0]);
        EntityTag.registerSpawnedOnlyMechanism("goat_ram", false, EntityTag.class, (object, mechanism, input) -> {
            Entity patt5659$temp = object.getBukkitEntity();
            if (patt5659$temp instanceof Goat) {
                Goat goat = (Goat)patt5659$temp;
                goat.ram(input.getLivingEntity());
            }
        });
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
            EntityTag.registerSpawnedOnlyMechanism("damage_item", false, MapTag.class, (object, mechanism, input) -> {
                ElementTag slot = input.getElement("slot");
                ElementTag amount = input.getElement("amount");
                if (slot == null || !slot.matchesEnum(EquipmentSlot.class)) {
                    mechanism.echoError("Must specify a valid equipment slot to damage.");
                    return;
                }
                if (amount == null || !amount.isInt()) {
                    mechanism.echoError("Must specify a valid amount to damage this item for.");
                    return;
                }
                object.getLivingEntity().damageItemStack(slot.asEnum(EquipmentSlot.class), amount.asInt());
            });
        }
    }
}

