/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;

public class AreaEffectCloudApplyScriptEvent
extends BukkitScriptEvent
implements Listener {
    public AreaEffectCloudApplyEvent event;
    public EntityTag entity;

    public AreaEffectCloudApplyScriptEvent() {
        this.registerCouldMatcher("area effect cloud applies");
        this.registerDetermination("affected_entities", ListTag.class, (evt, context, list) -> {
            evt.event.getAffectedEntities().clear();
            for (EntityTag entity : list.filter(EntityTag.class, context)) {
                if (entity.isLivingEntity()) {
                    evt.event.getAffectedEntities().add(entity.getLivingEntity());
                    continue;
                }
                Debug.echoError(entity + " is not a living entity!");
            }
        });
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            case "affected_entities" -> new ListTag(this.event.getAffectedEntities(), EntityTag::new);
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onAreaEffectCloudApply(AreaEffectCloudApplyEvent event) {
        this.event = event;
        this.entity = new EntityTag((Entity)event.getEntity());
        this.fire((Event)event);
    }
}

