/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerStandsOnScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerStandsOnScriptEvent instance;
    PlayerInteractEvent event;
    LocationTag location;
    MaterialTag material;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player stands on")) {
            return false;
        }
        return PlayerStandsOnScriptEvent.couldMatchBlock(path.eventArgLowerAt(3));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(3);
        if (mat.length() > 0 && !mat.equals("in") && !this.material.tryAdvancedMatcher(mat)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.getPlayerFrom((Entity)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerStandsOn(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        this.material = new MaterialTag(event.getClickedBlock());
        this.location = new LocationTag(event.getClickedBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

