/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class EntityTeleportScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public LocationTag from;
    public LocationTag to;
    public String cause;
    public EntityTeleportEvent event;
    public PlayerTeleportEvent pEvent;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("teleports")) {
            return false;
        }
        return EntityTeleportScriptEvent.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!EntityTeleportScriptEvent.runGenericSwitchCheck(path, "cause", this.cause)) {
            return false;
        }
        if (!this.runInCheck(path, this.from)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        LocationTag new_to;
        String determination = determinationObj.toString();
        String dlow = CoreUtilities.toLowerCase(determination);
        if (dlow.startsWith("origin:")) {
            LocationTag new_from = LocationTag.valueOf(determination.substring("origin:".length()), this.getTagContext(path));
            if (new_from != null) {
                this.from = new_from;
                if (this.event != null) {
                    this.event.setFrom((Location)new_from);
                } else {
                    this.pEvent.setFrom((Location)new_from);
                }
                return true;
            }
        } else if (dlow.startsWith("destination:")) {
            LocationTag new_to2 = LocationTag.valueOf(determination.substring("destination:".length()), this.getTagContext(path));
            if (new_to2 != null) {
                this.to = new_to2;
                if (this.event != null) {
                    this.event.setTo((Location)new_to2);
                } else {
                    this.pEvent.setTo((Location)new_to2);
                }
                return true;
            }
        } else if (LocationTag.matches(determination) && (new_to = LocationTag.valueOf(determination, this.getTagContext(path))) != null) {
            this.to = new_to;
            if (this.event != null) {
                this.event.setTo((Location)new_to);
            } else {
                this.pEvent.setTo((Location)new_to);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "origin": {
                return this.from;
            }
            case "destination": {
                return this.to;
            }
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "cause": {
                return new ElementTag(this.cause);
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityTeleports(EntityTeleportEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        this.to = new LocationTag(event.getTo());
        this.from = new LocationTag(event.getFrom());
        this.entity = new EntityTag(event.getEntity());
        this.cause = event instanceof EntityPortalEvent ? "ENTITY_PORTAL" : "ENTITY_TELEPORT";
        this.event = event;
        this.pEvent = null;
        this.fire((Event)event);
    }

    @EventHandler
    public void onPlayerTeleports(PlayerTeleportEvent event) {
        this.from = new LocationTag(event.getFrom());
        this.to = new LocationTag(event.getTo());
        this.entity = new EntityTag((Entity)event.getPlayer());
        this.cause = event.getCause().name();
        this.event = null;
        this.pEvent = event;
        this.fire((Event)event);
    }
}

