/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;

public class EntityShouldBurn
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Zombie || entity.getBukkitEntity() instanceof Skeleton || entity.getBukkitEntity() instanceof Phantom;
    }

    @Override
    public ElementTag getPropertyValue() {
        Entity entity = this.getEntity();
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            return new ElementTag(zombie.shouldBurnInDay());
        }
        entity = this.getEntity();
        if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            return new ElementTag(skeleton.shouldBurnInDay());
        }
        return new ElementTag(this.as(Phantom.class).shouldBurnInDay());
    }

    @Override
    public String getPropertyId() {
        return "should_burn";
    }

    @Override
    public void setPropertyValue(ElementTag param, Mechanism mechanism) {
        if (mechanism.requireBoolean()) {
            Entity entity = this.getEntity();
            if (entity instanceof Zombie) {
                Zombie zombie = (Zombie)entity;
                zombie.setShouldBurnInDay(param.asBoolean());
            } else {
                entity = this.getEntity();
                if (entity instanceof Skeleton) {
                    Skeleton skeleton = (Skeleton)entity;
                    skeleton.setShouldBurnInDay(param.asBoolean());
                } else {
                    this.as(Phantom.class).setShouldBurnInDay(param.asBoolean());
                }
            }
        }
    }

    public static void register() {
        EntityShouldBurn.autoRegister("should_burn", EntityShouldBurn.class, ElementTag.class, false, new String[0]);
    }
}

