/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import io.papermc.paper.event.entity.EntityMoveEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityStepsOnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityMoveEvent event;
    public EntityTag entity;
    public LocationTag location;
    public MaterialTag material;

    public EntityStepsOnScriptEvent() {
        this.registerCouldMatcher("<entity> steps on <block>");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return !path.eventLower.startsWith("player");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!path.tryArgObject(3, this.material)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            case "location" -> this.location;
            case "previous_location" -> new LocationTag(this.event.getFrom());
            case "new_location" -> new LocationTag(this.event.getTo());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void entityStepsOnBlockEvent(EntityMoveEvent event) {
        if (!event.hasChangedBlock()) {
            return;
        }
        this.location = new LocationTag(event.getTo().clone().subtract(0.0, 0.05, 0.0));
        if (!Utilities.isLocationYSafe(this.location)) {
            return;
        }
        this.material = new MaterialTag(this.location.getBlock());
        this.entity = new EntityTag((Entity)event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

