/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.papermc.paper.event.player.PlayerLoomPatternSelectEvent;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;

public class PlayerLoomPatternSelectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerLoomPatternSelectEvent event;

    public PlayerLoomPatternSelectScriptEvent() {
        this.registerCouldMatcher("player selects loom pattern");
        this.registerSwitches("type");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getLoomInventory().getLocation())) {
            return false;
        }
        if (!path.tryObjectSwitch("type", new ElementTag((Enum<?>)this.event.getPatternType()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "loom" -> InventoryTag.mirrorBukkitInventory((Inventory)this.event.getLoomInventory());
            case "pattern" -> new ElementTag((Enum<?>)this.event.getPatternType());
            default -> super.getContext(name);
        };
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("pattern:")) {
            ElementTag value = new ElementTag(lower.substring("pattern:".length()));
            this.event.setPatternType(value.asEnum(PatternType.class));
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @EventHandler
    public void onPlayerSelectsLoomPattern(PlayerLoomPatternSelectEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

