/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.WorldTag;
import org.bukkit.Chunk;
import org.bukkit.Location;

public class ChunkCoordinate {
    public final int x;
    public final int z;
    public final String worldName;

    public ChunkCoordinate(int _x, int _z, String _worldName) {
        this.x = _x;
        this.z = _z;
        this.worldName = _worldName;
    }

    public ChunkCoordinate(Location location) {
        this.x = location.getBlockX() >> 4;
        this.z = location.getBlockZ() >> 4;
        this.worldName = location.getWorld().getName();
    }

    public ChunkCoordinate(Chunk chunk) {
        this.x = chunk.getX();
        this.z = chunk.getZ();
        this.worldName = chunk.getWorld().getName();
    }

    public int hashCode() {
        return this.x + this.z + this.worldName.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChunkCoordinate)) {
            return false;
        }
        return this.equals((ChunkCoordinate)other);
    }

    public boolean equals(ChunkCoordinate other) {
        if (other == null) {
            return false;
        }
        return this.x == other.x && this.z == other.z && this.worldName.equals(other.worldName);
    }

    public String toString() {
        return this.x + "," + this.z + "," + this.worldName;
    }

    public ChunkTag getChunk() {
        return new ChunkTag(new WorldTag(this.worldName), this.x, this.z);
    }
}

