/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashSet;
import java.util.Set;

public class LegacyNamingHelper<T extends Enum<T>> {
    private final Set<String> modernNames;
    private final Class<T> enumType;

    public LegacyNamingHelper(Class<T> enumType) {
        this.enumType = enumType;
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        this.modernNames = new HashSet<String>(enumConstants.length);
        for (Enum enumConstant : enumConstants) {
            this.modernNames.add(enumConstant.name());
        }
    }

    public T fromName(String name, TagContext context) {
        T value;
        String nameUpper = CoreUtilities.toUpperCase(name);
        try {
            value = Enum.valueOf(this.enumType, nameUpper);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && !this.modernNames.contains(nameUpper)) {
            BukkitImplDeprecations.oldSpigotNames.warn(context);
        }
        return value;
    }
}

