/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.properties.entity.EntityColor;
import com.denizenscript.denizen.utilities.LegacyNamingHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Warden;

public class MultiVersionHelper1_19 {
    public static boolean colorIsApplicable(EntityType type) {
        return type == EntityType.FROG || type == EntityType.BOAT || type == EntityType.CHEST_BOAT;
    }

    public static String getColor(Entity entity) {
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            return String.valueOf(frog.getVariant());
        }
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            return boat.getBoatType().name();
        }
        return null;
    }

    public static ListTag getAllowedColors(EntityType type) {
        if (type == EntityType.FROG) {
            return EntityColor.listTypes(Frog.Variant.class);
        }
        if (type == EntityType.BOAT || type == EntityType.CHEST_BOAT) {
            return EntityColor.listTypes(Boat.Type.class);
        }
        return null;
    }

    public static void setColor(Entity entity, Mechanism mech) {
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            LegacyNamingHelper.requireType(mech, Frog.Variant.class).ifPresent(arg_0 -> ((Frog)frog).setVariant(arg_0));
        } else if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            if (mech.requireEnum(Boat.Type.class)) {
                boat.setBoatType(mech.getValue().asEnum(Boat.Type.class));
            }
        }
    }

    public static MapTag interactionToMap(Interaction.PreviousInteraction interaction, World world) {
        if (interaction == null) {
            return null;
        }
        MapTag result = new MapTag();
        result.putObject("player", (ObjectTag)new PlayerTag(interaction.getPlayer()));
        result.putObject("duration", (ObjectTag)new DurationTag((double)(world.getGameTime() - interaction.getTimestamp()) / 20.0));
        result.putObject("raw_game_time", (ObjectTag)new ElementTag(interaction.getTimestamp()));
        return result;
    }

    public static ElementTag getWardenAngerLevel(Warden warden) {
        return new ElementTag((Enum<?>)warden.getAngerLevel());
    }
}

